/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.cache;

import com.github.cao.awa.catheter.Catheter;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class SepalsLivingTargetCache
extends NearestVisibleLivingEntities {
    private final LivingEntity[] entities;
    private final Player[] players;
    private final Object2BooleanOpenHashMap<LivingEntity> directSuccess;
    private final Predicate<LivingEntity> compute;

    public SepalsLivingTargetCache(ServerLevel world, LivingEntity owner, LivingEntity[] entities, Player[] players) {
        super(world, owner, Collections.EMPTY_LIST);
        this.entities = entities;
        this.players = players;
        this.directSuccess = new Object2BooleanOpenHashMap(entities.length);
        Predicate<LivingEntity> predicate = entity -> Sensor.isEntityTargetable((ServerLevel)world, (LivingEntity)owner, (LivingEntity)entity);
        this.compute = entity -> this.directSuccess.computeIfAbsent(entity, predicate);
    }

    public Optional<LivingEntity> findClosest(Predicate<LivingEntity> predicate) {
        LivingEntity[] entities;
        for (LivingEntity entity : entities = this.entities) {
            if (!predicate.test(entity) || !this.compute.test(entity)) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public Optional<Player> findFirstPlayer(Predicate<Player> predicate) {
        return this.findFirstPlayer(predicate, () -> true);
    }

    public Optional<Player> findFirstPlayer(Predicate<Player> predicate, BooleanSupplier canTargetPredicateWhen) {
        Player[] players;
        for (Player player : players = this.players) {
            if (!predicate.test(player) || !canTargetPredicateWhen.getAsBoolean() || !this.compute.test((LivingEntity)player)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public Optional<Player> findFirstPlayer(Predicate<Player> predicate, Predicate<Player> canTargetPredicateWhen) {
        Player[] players;
        for (Player player : players = this.players) {
            if (!predicate.test(player) || !canTargetPredicateWhen.test(player) || !this.compute.test((LivingEntity)player)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public Iterable<LivingEntity> findAll(Predicate<LivingEntity> predicate) {
        return () -> this.find(predicate).iterator();
    }

    public Stream<LivingEntity> find(Predicate<LivingEntity> predicate) {
        return Arrays.stream(this.entities).filter(entity -> predicate.test((LivingEntity)entity) && this.compute.test((LivingEntity)entity));
    }

    public List<LivingEntity> collect(Predicate<LivingEntity> predicate) {
        return Catheter.of((Object[])this.entities).filterTo(entity -> predicate.test((LivingEntity)entity) && this.compute.test((LivingEntity)entity)).list();
    }

    public boolean contains(LivingEntity target) {
        LivingEntity[] entities;
        for (LivingEntity entity : entities = this.entities) {
            if (entity != target) continue;
            return this.compute.test(entity);
        }
        return false;
    }

    public boolean contains(Predicate<LivingEntity> predicate) {
        LivingEntity[] entities;
        for (LivingEntity entity : entities = this.entities) {
            if (!predicate.test(entity) || !this.compute.test(entity)) continue;
            return true;
        }
        return false;
    }
}

