/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.weight.SepalsWeighting;
import com.github.cao.awa.sepals.weight.WeightTable;
import com.github.cao.awa.sepals.weight.result.WeightingResult;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SepalsLongJumpTask<E extends Mob>
extends Behavior<E> {
    private static final int[] RAM_RANGES = new int[]{65, 70, 75, 80};
    private final UniformInt cooldownRange;
    protected final int verticalRange;
    protected final int horizontalRange;
    protected final double maxRange;
    protected Catheter<BlockPos> targets = null;
    protected Catheter<Target> precalculatedTargets = null;
    protected int precalculatedRange = 0;
    private int precalculatingIndex = 0;
    protected Vec3 lastPos = null;
    protected boolean isNoRange = false;
    @Nullable
    protected Vec3 lastTarget;
    protected int cooldown;
    protected long targetTime;
    private final Function<E, SoundEvent> entityToSound;
    private final BiPredicate<E, BlockPos> jumpToPredicate;

    public SepalsLongJumpTask(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEvent> entityToSound) {
        this(cooldownRange, verticalRange, horizontalRange, maxRange, entityToSound, LongJumpToRandomPos::defaultAcceptableLandingSpot);
    }

    public static <E extends Mob> boolean shouldJumpTo(E entity, BlockState posDownState, PathType pathNodeType) {
        return posDownState.isSolidRender() && entity.getPathfindingMalus(pathNodeType) == 0.0f;
    }

    public SepalsLongJumpTask(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEvent> entityToSound, BiPredicate<E, BlockPos> jumpToPredicate) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)MemoryStatus.VALUE_ABSENT), 200);
        this.cooldownRange = cooldownRange;
        this.verticalRange = verticalRange;
        this.horizontalRange = horizontalRange;
        this.maxRange = maxRange;
        this.entityToSound = entityToSound;
        this.jumpToPredicate = jumpToPredicate;
    }

    protected boolean shouldRun(ServerLevel serverWorld, Mob mobEntity) {
        boolean bl;
        boolean bl2 = bl = mobEntity.onGround() && !mobEntity.isInWater() && !mobEntity.isInLava() && !serverWorld.getBlockState(mobEntity.blockPosition()).is(Blocks.HONEY_BLOCK);
        if (!bl) {
            mobEntity.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)(this.cooldownRange.sample(serverWorld.random) / 2));
        }
        return bl;
    }

    protected boolean shouldKeepRunning(ServerLevel serverWorld, Mob mobEntity, long l) {
        boolean bl;
        boolean bl2 = bl = this.lastPos != null && this.lastPos.equals((Object)mobEntity.position()) && this.cooldown > 0 && !mobEntity.isInWater() && (this.lastTarget != null || this.targets.isPresent());
        if (!bl && mobEntity.getBrain().getMemory(MemoryModuleType.LONG_JUMP_MID_JUMP).isEmpty()) {
            mobEntity.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)(this.cooldownRange.sample(serverWorld.random) / 2));
            mobEntity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        }
        return bl;
    }

    protected void run(ServerLevel serverWorld, E mobEntity, long l) {
        this.lastTarget = null;
        this.cooldown = 20;
        this.lastPos = mobEntity.position();
        BlockPos blockPos = mobEntity.blockPosition();
        int i = blockPos.getX();
        int j = blockPos.getY();
        int k = blockPos.getZ();
        this.precalculatedRange = 0;
        this.precalculatingIndex = 0;
        this.isNoRange = false;
        this.targets = Catheter.of(SepalsLongJumpTask.makeBlockPos(i - this.horizontalRange, j - this.verticalRange, k - this.horizontalRange, i + this.horizontalRange, j + this.verticalRange, k + this.horizontalRange)).distinct().filter(blockPos2 -> !blockPos2.equals((Object)blockPos)).ifPresent(cather -> {
            this.precalculatedTargets = new Catheter((Object[])new Target[cather.count()]).arrayGenerator(Target[]::new);
        }).whenAlternate((Object)0, (min, blockPos2) -> {
            int weight = Mth.ceil((double)blockPos.distSqr((Vec3i)blockPos2));
            int max = min + weight;
            this.precalculatedTargets.fetch(this.precalculatingIndex++, (Object)new Target(blockPos2.immutable(), weight, (int)min, max));
            return max;
        }, precalculatedRange -> {
            this.precalculatedRange = precalculatedRange;
        });
        if (this.targets.isPresent() && this.precalculatedRange / ((Target)this.precalculatedTargets.fetch(0)).weight() == this.precalculatedTargets.count()) {
            this.isNoRange = true;
        }
    }

    private static List<BlockPos> makeBlockPos(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        ObjectArrayList blockPosList = ApricotCollectionFactor.arrayList();
        BlockPos.betweenClosed((int)startX, (int)startY, (int)startZ, (int)endX, (int)endY, (int)endZ).forEach(((List)blockPosList)::add);
        return blockPosList;
    }

    protected void keepRunning(ServerLevel serverWorld, E mobEntity, long l) {
        if (this.lastTarget == null) {
            --this.cooldown;
            this.findTarget(serverWorld, mobEntity, l);
        } else if (l - this.targetTime >= 40L) {
            mobEntity.setYRot(((Mob)mobEntity).yBodyRot);
            mobEntity.setDiscardFriction(true);
            double d = this.lastTarget.length();
            double e = d + (double)mobEntity.getJumpBoostPower();
            mobEntity.setDeltaMovement(this.lastTarget.scale(e / d));
            mobEntity.getBrain().setMemory(MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)true);
            serverWorld.playSound(null, mobEntity, this.entityToSound.apply(mobEntity), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    protected void findTarget(ServerLevel world, E entity, long time) {
        while (this.targets.isPresent()) {
            Vec3 vec3d2;
            Target target = this.getTarget(world);
            if (target == null || !this.canJumpTo(entity, target.pos) || (vec3d2 = this.getJumpingVelocity((Level)world, (Mob)entity, Vec3.atCenterOf((Vec3i)target.pos))) == null) continue;
            entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(target.pos));
            Path path = entity.getNavigation().createPath(target.pos, 0, 8);
            if (path != null && path.canReach()) continue;
            this.lastTarget = vec3d2;
            this.targetTime = time;
            return;
        }
    }

    protected Target getTarget(ServerLevel world) {
        if (this.targets.isPresent()) {
            WeightingResult<Target> target;
            if (this.isNoRange) {
                int index = world.random.nextInt(this.precalculatedTargets.count());
                target = new WeightingResult<Target>((Target)this.precalculatedTargets.fetch(index), index);
            } else {
                target = SepalsWeighting.getRandom(world.random, this.precalculatedTargets, t -> this.precalculatedRange);
            }
            if (target == null) {
                return null;
            }
            this.targets.removeWithIndex(target.index());
            this.precalculatedTargets.removeWithIndex(target.index());
            Target value = target.value();
            if (value == null) {
                return null;
            }
            this.precalculatedRange -= value.weight();
            return value;
        }
        return null;
    }

    private boolean canJumpTo(E entity, BlockPos targetPos) {
        BlockPos entityPos = entity.blockPosition();
        if (entityPos.getX() == targetPos.getX() && entityPos.getZ() == targetPos.getZ()) {
            return false;
        }
        return this.jumpToPredicate.test(entity, targetPos);
    }

    @Nullable
    protected Vec3 getJumpingVelocity(Level world, Mob entity, Vec3 targetPos) {
        float f = (float)(entity.getAttributeValue(Attributes.JUMP_STRENGTH) * this.maxRange);
        SepalsLongJumpTask.shuffle(RAM_RANGES, world.random);
        return LongJumpUtil.calculateJumpVectorForAngle((Mob)entity, (Vec3)targetPos, (float)f, (int)RAM_RANGES[0], (boolean)true).orElseGet(() -> LongJumpUtil.calculateJumpVectorForAngle((Mob)entity, (Vec3)targetPos, (float)f, (int)RAM_RANGES[1], (boolean)true).orElseGet(() -> LongJumpUtil.calculateJumpVectorForAngle((Mob)entity, (Vec3)targetPos, (float)f, (int)RAM_RANGES[2], (boolean)true).orElseGet(() -> LongJumpUtil.calculateJumpVectorForAngle((Mob)entity, (Vec3)targetPos, (float)f, (int)RAM_RANGES[3], (boolean)true).orElse(null))));
    }

    public static void shuffle(int[] ranges, RandomSource random) {
        int i;
        for (int j = i = ranges.length; j > 1; --j) {
            int to;
            int k = random.nextInt(j);
            int posFrom = j - 1;
            int from = ranges[posFrom];
            ranges[posFrom] = to = ranges[k];
            ranges[k] = from;
        }
    }

    public record Target(BlockPos pos, int weight, int min, int max) implements WeightTable<Target>
    {
        @Override
        public Target element() {
            return this;
        }
    }
}

