/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task;

import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public abstract class SepalsSingleTickTask<E extends LivingEntity>
extends OneShot<E>
implements DetailedDebuggableTask {
    private ServerLevel currentWorld;
    private E currentEntity;
    private Brain<?> currentBrain;
    @VisibleForDebug
    private long currentTime;

    public boolean trigger(ServerLevel world, E entity, long time) {
        this.currentWorld = world;
        this.currentEntity = entity;
        this.currentBrain = entity.getBrain();
        this.currentTime = time;
        return this.complete(world, entity, time);
    }

    public abstract boolean complete(ServerLevel var1, E var2, long var3);

    public <U> boolean require(MemoryModuleType<U> memoryType, Predicate<U> action) {
        return this.currentBrain().getMemory(memoryType).filter(action).isPresent();
    }

    public <U> void remember(MemoryModuleType<U> memoryType, U value) {
        this.currentBrain().setMemory(memoryType, value);
    }

    public ServerLevel currentWorld() {
        return this.currentWorld;
    }

    public E currentEntity() {
        return this.currentEntity;
    }

    public Brain<?> currentBrain() {
        return this.currentBrain;
    }

    public long currentTime() {
        return this.currentTime;
    }

    @Override
    public boolean alwaysRunning() {
        return true;
    }

    public String toString() {
        return this.information();
    }
}

