/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.biased;

import com.github.cao.awa.sepals.entity.ai.task.SepalsLongJumpTask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;

public class SepalsBiasedLongJumpTask<E extends Mob>
extends SepalsLongJumpTask<E> {
    private final TagKey<Block> favoredBlocks;
    private final float biasChance;
    private final List<SepalsLongJumpTask.Target> unfavoredTargets = new ArrayList<SepalsLongJumpTask.Target>();
    private boolean useBias;

    public SepalsBiasedLongJumpTask(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEvent> entityToSound, TagKey<Block> favoredBlocks, float biasChance, BiPredicate<E, BlockPos> jumpToPredicate) {
        super(cooldownRange, verticalRange, horizontalRange, maxRange, entityToSound, jumpToPredicate);
        this.favoredBlocks = favoredBlocks;
        this.biasChance = biasChance;
    }

    @Override
    protected void run(ServerLevel serverWorld, E mobEntity, long l) {
        super.run(serverWorld, mobEntity, l);
        this.unfavoredTargets.clear();
        this.useBias = mobEntity.getRandom().nextFloat() < this.biasChance;
    }

    @Override
    protected SepalsLongJumpTask.Target getTarget(ServerLevel world) {
        if (this.useBias) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            while (this.targets.isPresent()) {
                SepalsLongJumpTask.Target target = super.getTarget(world);
                if (!this.addUnfavored(world, mutable, target)) continue;
                return target;
            }
            return this.unfavoredTargets.isEmpty() ? null : this.unfavoredTargets.removeFirst();
        }
        return super.getTarget(world);
    }

    private boolean addUnfavored(ServerLevel world, BlockPos.MutableBlockPos mutable, SepalsLongJumpTask.Target target) {
        if (world.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)target.pos(), Direction.DOWN)).is(this.favoredBlocks)) {
            return true;
        }
        this.unfavoredTargets.add(target);
        return false;
    }
}

