/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.look;

import com.github.cao.awa.sepals.entity.ai.cache.SepalsLivingTargetCache;
import com.github.cao.awa.sepals.entity.ai.task.SepalsSingleTickTask;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;

public class SepalsLookAtPlayerTask
extends SepalsSingleTickTask<LivingEntity> {
    private final float maxDistance;

    public SepalsLookAtPlayerTask(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public static SepalsLookAtPlayerTask create(float maxDistance) {
        return new SepalsLookAtPlayerTask(maxDistance);
    }

    @Override
    public boolean complete(ServerLevel world, LivingEntity entity, long time) {
        return this.require(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, cache -> {
            Optional<Player> optional;
            Predicate<LivingEntity> distance = target -> target.distanceToSqr((Entity)entity) <= (double)this.maxDistance;
            if (cache instanceof SepalsLivingTargetCache) {
                SepalsLivingTargetCache sepalsCache = (SepalsLivingTargetCache)((Object)cache);
                optional = entity.isVehicle() ? sepalsCache.findFirstPlayer(distance::test, target -> !entity.hasPassenger((Entity)target)) : sepalsCache.findFirstPlayer(distance::test);
            } else {
                Optional<Object> optional2 = optional = entity.isVehicle() ? cache.findClosest(target -> distance.test((LivingEntity)target) && !entity.hasPassenger((Entity)target)) : cache.findClosest(distance);
            }
            if (optional.isEmpty()) {
                return false;
            }
            this.remember(MemoryModuleType.LOOK_TARGET, new EntityTracker((Entity)optional.get(), true));
            return true;
        });
    }

    @Override
    public String information() {
        return "LookAtPlayerTask(distance=" + this.maxDistance + ")";
    }
}

