/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.predicate;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class SepalsEntityPredicates {
    public static Predicate<Entity> quickCanBePushedBy(Entity currentEntity) {
        Team.CollisionRule currentCollisionRule;
        PlayerTeam currentTeam = currentEntity.getTeam();
        if (currentTeam == null) {
            currentCollisionRule = Team.CollisionRule.ALWAYS;
        } else {
            currentCollisionRule = currentTeam.getCollisionRule();
            if (currentCollisionRule == Team.CollisionRule.NEVER) {
                return Predicates.alwaysFalse();
            }
        }
        boolean currentEntityNoPushOwnTeam = currentCollisionRule != Team.CollisionRule.PUSH_OWN_TEAM;
        boolean currentEntityNoPushOtherTeams = currentCollisionRule != Team.CollisionRule.PUSH_OTHER_TEAMS;
        boolean currentEntityIsClient = currentEntity.level().isClientSide();
        return arg_0 -> SepalsEntityPredicates.lambda$quickCanBePushedBy$0(currentEntityIsClient, currentEntityNoPushOwnTeam, currentEntityNoPushOtherTeams, (Team)currentTeam, arg_0);
    }

    private static /* synthetic */ boolean lambda$quickCanBePushedBy$0(boolean currentEntityIsClient, boolean currentEntityNoPushOwnTeam, boolean currentEntityNoPushOtherTeams, Team currentTeam, Entity otherEntity) {
        PlayerTeam otherTeam;
        if (otherEntity.isSpectator() || !otherEntity.isPushable()) {
            return false;
        }
        if (currentEntityIsClient) {
            if (otherEntity instanceof Player) {
                Player playerEntity = (Player)otherEntity;
                if (!playerEntity.isLocalPlayer()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((otherTeam = otherEntity.getTeam()) == null) {
            return currentEntityNoPushOwnTeam && currentEntityNoPushOtherTeams;
        }
        Team.CollisionRule otherCollisionRule = otherTeam.getCollisionRule();
        if (otherTeam.isAlliedTo(currentTeam)) {
            boolean otherEntityNoPushOwnTeam = otherCollisionRule != Team.CollisionRule.PUSH_OWN_TEAM;
            return currentEntityNoPushOwnTeam && otherEntityNoPushOwnTeam;
        }
        boolean otherEntityNoPushOtherTeams = otherCollisionRule != Team.CollisionRule.PUSH_OTHER_TEAMS;
        return currentEntityNoPushOtherTeams && otherEntityNoPushOtherTeams;
    }
}

