/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.entity.ai.brain.TaskDelegate;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsTaskStatus;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Brain.class})
public abstract class BrainMixin<E extends LivingEntity>
implements TaskDelegate<E> {
    @Shadow
    @Final
    private Map<Integer, Map<Activity, Set<BehaviorControl<? super E>>>> availableBehaviorsByPriority;
    @Shadow
    @Final
    private Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> memories;
    @Unique
    private Catheter<BehaviorControl<? super E>> taskCatheter;
    @Unique
    private Catheter<BehaviorControl<? super E>> runningTasks;
    @Unique
    private Catheter<Map.Entry<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>>> memoriesCatheter;

    @Shadow
    public abstract <U> void eraseMemory(MemoryModuleType<U> var1);

    @Shadow
    public abstract boolean isActive(Activity var1);

    @Inject(method={"<init>(Ljava/util/Collection;Ljava/util/Collection;Lcom/google/common/collect/ImmutableList;Ljava/util/function/Supplier;)V"}, at={@At(value="RETURN")})
    public void initBrain(Collection<? extends MemoryModuleType<?>> memories, Collection<? extends SensorType<? extends Sensor<? super E>>> sensors, ImmutableList<?> memoryEntries, Supplier<Codec<Brain<E>>> codecSupplier, CallbackInfo ci) {
        this.constructTasks();
        this.constructMemories();
    }

    @Unique
    private void constructTasks() {
        this.taskCatheter = Catheter.of(this.availableBehaviorsByPriority.values()).collectionFlatTo(Map::entrySet).filter(this::isActive, Map.Entry::getKey).collectionFlatTo(Map.Entry::getValue);
    }

    @Unique
    private Catheter<BehaviorControl<? super E>> getTasks() {
        if (this.taskCatheter == null) {
            this.constructTasks();
        }
        return this.taskCatheter;
    }

    @Unique
    private Catheter<BehaviorControl<? super E>> getRunningTasks() {
        if (this.runningTasks == null) {
            this.constructRunningTasks();
        }
        return this.runningTasks;
    }

    @Unique
    private void constructRunningTasks() {
        this.runningTasks = this.getTasks().filterTo(SepalsTaskStatus::isRunning, BehaviorControl::getStatus);
    }

    @Unique
    private Catheter<Map.Entry<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>>> getMemories() {
        if (this.memoriesCatheter == null) {
            this.constructMemories();
        }
        return this.memoriesCatheter;
    }

    @Unique
    private void constructMemories() {
        this.memoriesCatheter = Catheter.of(this.memories.entrySet());
    }

    @Inject(method={"setMemoryInternal(Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;Ljava/util/Optional;)V"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    private <U> void setMemory(MemoryModuleType<U> type, Optional<? extends ExpirableValue<?>> memory, CallbackInfo ci) {
        this.constructMemories();
    }

    @Redirect(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/Brain;forgetOutdatedMemories()V"))
    private void tickMemories(Brain<E> instance) {
        this.getMemories().each(entry -> {
            Optional memOp = (Optional)entry.getValue();
            if (memOp.isPresent()) {
                ExpirableValue memory = (ExpirableValue)memOp.get();
                if (memory.hasExpired()) {
                    this.eraseMemory((MemoryModuleType)entry.getKey());
                }
                memory.tick();
            }
        });
    }

    @Redirect(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/Brain;startEachNonRunningBehavior(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void startTasks(Brain<E> instance, ServerLevel world, E entity) {
        long time = entity.level().getGameTime();
        Catheter running = this.getTasks().filterTo(task -> {
            if (SepalsTaskStatus.isStopped(task.getStatus())) {
                return task.tryStart(world, entity, time);
            }
            return true;
        });
        if (this.runningTasks != null) {
            this.runningTasks.merge(running);
        } else {
            this.runningTasks = running;
        }
    }

    @Redirect(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/Brain;tickEachRunningBehavior(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void updateTasks(Brain<E> instance, ServerLevel world, E entity) {
        long time = entity.level().getGameTime();
        this.getRunningTasks().filter(task -> {
            boolean running = SepalsTaskStatus.isRunning(task.getStatus());
            if (running) {
                task.tickOrStop(world, entity, time);
            }
            return running;
        });
    }

    @Inject(method={"stopAll(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopAllTasks(ServerLevel world, E entity, CallbackInfo ci) {
        long time = entity.level().getGameTime();
        this.getRunningTasks().each(task -> task.doStop(world, entity, time));
        this.runningTasks = null;
        ci.cancel();
    }

    @Inject(method={"addActivityAndRemoveMemoriesWhenStopped(Lnet/minecraft/world/entity/schedule/Activity;Lcom/google/common/collect/ImmutableList;Ljava/util/Set;Ljava/util/Set;)V"}, at={@At(value="RETURN")})
    private void updateTasks(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<?>>> indexedTasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories, Set<MemoryModuleType<?>> forgettingMemories, CallbackInfo ci) {
        this.constructTasks();
    }

    @Inject(method={"removeAllBehaviors()V"}, at={@At(value="RETURN")})
    private void clearTasks(CallbackInfo ci) {
        this.taskCatheter = null;
        this.runningTasks = null;
    }

    @Override
    public Catheter<BehaviorControl<? super E>> sepals$tasks() {
        return this.taskCatheter.dump();
    }

    @Inject(method={"setActiveActivity(Lnet/minecraft/world/entity/schedule/Activity;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void resetPossibleActivities(Activity except, CallbackInfo ci) {
        this.constructTasks();
    }
}

