/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain.frog;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.entity.ai.brain.frog.SepalsFrogBrain;
import com.github.cao.awa.sepals.entity.ai.task.biased.SepalsBiasedLongJumpTask;
import com.github.cao.awa.sepals.entity.ai.task.look.SepalsLookAtMobWithIntervalTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.LongJumpMidJump;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FrogAi.class})
public abstract class FrogBrainMixin {
    @Shadow
    @Final
    private static UniformInt TIME_BETWEEN_LONG_JUMPS;

    @Inject(method={"initJumpActivity(Lnet/minecraft/world/entity/ai/Brain;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addLongJumpActivities(Brain<Frog> brain, CallbackInfo ci) {
        if (Sepals.CONFIG.isEnableSepalsBiasedLongJumpTask()) {
            brain.addActivityWithConditions(Activity.LONG_JUMP, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LongJumpMidJump(TIME_BETWEEN_LONG_JUMPS, SoundEvents.FROG_STEP)), (Object)Pair.of((Object)1, new SepalsBiasedLongJumpTask<Frog>(TIME_BETWEEN_LONG_JUMPS, 2, 4, 3.5714288f, frog -> SoundEvents.FROG_LONG_JUMP, (TagKey<Block>)BlockTags.FROG_PREFER_JUMP_TO, 0.5f, SepalsFrogBrain::shouldJumpTo))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_ABSENT)));
            ci.cancel();
        }
    }

    @Redirect(method={"initIdleActivity(Lnet/minecraft/world/entity/ai/Brain;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/behavior/SetEntityLookTargetSometimes;create(Lnet/minecraft/world/entity/EntityType;FLnet/minecraft/util/valueproviders/UniformInt;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;"))
    private static BehaviorControl<LivingEntity> addIdleActivities(EntityType<?> type, float maxDistance, UniformInt interval) {
        if (Sepals.CONFIG.isEnableSepalsFrogLookAt()) {
            return SepalsLookAtMobWithIntervalTask.frogFollow(6.0f, UniformInt.of((int)30, (int)60));
        }
        return SetEntityLookTargetSometimes.create(type, (float)maxDistance, (UniformInt)interval);
    }

    @Redirect(method={"initSwimActivity(Lnet/minecraft/world/entity/ai/Brain;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/behavior/SetEntityLookTargetSometimes;create(Lnet/minecraft/world/entity/EntityType;FLnet/minecraft/util/valueproviders/UniformInt;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;"))
    private static BehaviorControl<LivingEntity> addSwimActivities(EntityType<?> type, float maxDistance, UniformInt interval) {
        if (Sepals.CONFIG.isEnableSepalsFrogLookAt()) {
            return SepalsLookAtMobWithIntervalTask.frogFollow(6.0f, UniformInt.of((int)30, (int)60));
        }
        return SetEntityLookTargetSometimes.create(type, (float)maxDistance, (UniformInt)interval);
    }

    @Redirect(method={"initLaySpawnActivity(Lnet/minecraft/world/entity/ai/Brain;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/behavior/SetEntityLookTargetSometimes;create(Lnet/minecraft/world/entity/EntityType;FLnet/minecraft/util/valueproviders/UniformInt;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;"))
    private static BehaviorControl<LivingEntity> addLaySpawnActivities(EntityType<?> type, float maxDistance, UniformInt interval) {
        if (Sepals.CONFIG.isEnableSepalsFrogLookAt()) {
            return SepalsLookAtMobWithIntervalTask.frogFollow(6.0f, UniformInt.of((int)30, (int)60));
        }
        return SetEntityLookTargetSometimes.create(type, (float)maxDistance, (UniformInt)interval);
    }
}

