/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain.sensor.nearest;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.Sepals;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.PlayerSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerSensor.class})
public abstract class NearestPlayersSensorMixin {
    @Inject(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void sense(ServerLevel world, LivingEntity entity, CallbackInfo ci) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            boolean canAttackToPlayer;
            Brain brain = entity.getBrain();
            Catheter<Player> players = this.collectBasicNearestPlayers((Level)world, entity, brain);
            boolean isVillager = entity instanceof Villager;
            boolean bl = canAttackToPlayer = entity instanceof Monster || entity instanceof NeutralMob;
            if (isVillager) {
                players.filter(NearestPlayersSensorMixin::isHero);
            }
            players.filter(player -> Sensor.isEntityTargetable((ServerLevel)world, (LivingEntity)entity, (LivingEntity)player));
            players.firstOrNull(player -> brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER, player));
            if (canAttackToPlayer) {
                players.filter(player -> Sensor.isEntityAttackable((ServerLevel)world, (LivingEntity)entity, (LivingEntity)player)).firstOrNull(player -> brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, Optional.ofNullable(player)));
            }
            ci.cancel();
        }
    }

    @Unique
    private Catheter<Player> collectBasicNearestPlayers(Level world, LivingEntity entity, Brain<?> brain) {
        return Catheter.of((Object[])((Player[])world.players().toArray(Player[]::new))).arrayGenerator(Player[]::new).filter(EntitySelector.NO_SPECTATORS).filter(player -> entity.closerThan((Entity)player, 16.0)).ifPresent(catheter -> {
            if (Sepals.CONFIG.isNearestLivingEntitiesSensorUseQuickSort()) {
                ObjectArrays.quickSort((Object[])((Player[])catheter.dArray()), Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).distanceToSqr(arg_0)));
            } else {
                Arrays.sort((Player[])catheter.dArray(), Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).distanceToSqr(arg_0)));
            }
        }).ifPresent(catheter -> brain.setMemory(MemoryModuleType.NEAREST_PLAYERS, (Object)catheter.list()));
    }

    @Unique
    private static boolean isHero(Player player) {
        return player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
    }
}

