/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain.sensor.villager;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.entity.ai.cache.SepalsLivingTargetCache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.VillagerBabiesSensor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VillagerBabiesSensor.class})
public abstract class VillagerBabiesSensorMixin {
    @Shadow
    protected abstract NearestVisibleLivingEntities getVisibleEntities(LivingEntity var1);

    @Inject(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void sense(ServerLevel world, LivingEntity entity, CallbackInfo ci) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            entity.getBrain().setMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES, this.getVisibleVillagerBabies(entity));
            ci.cancel();
        }
    }

    @Unique
    private List<LivingEntity> getVisibleVillagerBabies(LivingEntity entity) {
        NearestVisibleLivingEntities cache = this.getVisibleEntities(entity);
        if (cache instanceof SepalsLivingTargetCache) {
            SepalsLivingTargetCache sepalsCache = (SepalsLivingTargetCache)cache;
            return sepalsCache.collect(VillagerBabiesSensorMixin::isVillagerBaby);
        }
        return ImmutableList.copyOf((Iterable)cache.findAll(VillagerBabiesSensorMixin::isVillagerBaby));
    }

    @Unique
    private static boolean isVillagerBaby(LivingEntity entity) {
        return entity.getType() == EntityType.VILLAGER && entity.isBaby();
    }
}

