/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.world;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.item.BoxedEntitiesCache;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class WorldMixin
implements BoxedEntitiesCache {
    @Unique
    private static final Supplier<Map<Long, List<Entity>>> mapSupplier = () -> {
        if (Sepals.isAsyncLoaded) {
            return Collections.synchronizedMap(new Long2ObjectOpenHashMap());
        }
        return new Long2ObjectOpenHashMap();
    };
    @Unique
    private Map<Long, List<Entity>> entities = (Map)Manipulate.supply(mapSupplier::get);
    @Unique
    private Map<Long, List<Entity>> getByTypeEntities = (Map)Manipulate.supply(mapSupplier::get);

    @Unique
    public List<Entity> cachedGetByType(long hashCode) {
        if (this.getByTypeEntities == null) {
            this.getByTypeEntities = mapSupplier.get();
        }
        return this.getByTypeEntities.get(hashCode);
    }

    @Unique
    public void cacheGetByType(long hashCode, List<Entity> entities) {
        if (this.getByTypeEntities == null) {
            this.getByTypeEntities = mapSupplier.get();
        }
        this.getByTypeEntities.put(hashCode, entities);
    }

    @Override
    @Unique
    public void sepals$cache(AABB box, List<Entity> entities) {
        if (this.entities == null) {
            this.entities = mapSupplier.get();
        }
        this.entities.put(WorldMixin.boxHashCode(box), entities);
    }

    @Override
    @Unique
    public List<Entity> sepals$cached(AABB box) {
        if (this.entities == null) {
            this.entities = mapSupplier.get();
        }
        return this.entities.get(WorldMixin.boxHashCode(box));
    }

    @Override
    @Unique
    public void sepals$clearCache() {
        if (this.entities != null) {
            this.entities.clear();
        }
        if (this.getByTypeEntities != null) {
            this.getByTypeEntities.clear();
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOtherEntities(Entity except, AABB box, Predicate<? super Entity> predicate, CallbackInfoReturnable<List<Entity>> cir) {
        List<Entity> result;
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming() && (result = this.cached(box)) != null) {
            cir.setReturnValue(result);
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="RETURN")})
    public void cacheOtherEntities(Entity except, AABB box, Predicate<? super Entity> predicate, CallbackInfoReturnable<List<Entity>> cir) {
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
            this.cache(box, (List)cir.getReturnValue());
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends Entity> void getEntitiesByType(EntityTypeTest<T, ? extends T> filter, AABB box, Predicate<? super T> predicate, CallbackInfoReturnable<List<T>> cir) {
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
            long cacheKey = WorldMixin.boxHashCode(box);
            List<Entity> cached = this.cachedGetByType(cacheKey);
            if (cached == null) {
                return;
            }
            Catheter catheter = Catheter.of(cached);
            List result = catheter.filter(predicate).varyTo(entity -> (Entity)Manipulate.supply(() -> (Entity)filter.tryCast(entity))).exists().list();
            if (!result.isEmpty()) {
                cir.setReturnValue((Object)result);
            }
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="RETURN")})
    public void cacheEntitiesByType(EntityTypeTest<Entity, ? extends Entity> filter, AABB box, Predicate<? super Entity> predicate, CallbackInfoReturnable<List<Entity>> cir) {
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
            this.cacheGetByType(WorldMixin.boxHashCode(box), (List)cir.getReturnValue());
        }
    }

    @Unique
    private static long boxHashCode(AABB box) {
        int minHash = Arrays.hashCode(new double[]{box.minX, box.minY, box.minZ});
        int maxHash = Arrays.hashCode(new double[]{box.maxX, box.maxY, box.maxZ});
        return (long)minHash & 0xFFFFFFFFL | (long)maxHash << 32 & 0xFFFFFFFF00000000L;
    }

    @Unique
    private static long directBoxHashCode(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        long result = 1L;
        long bitsMinX = Double.doubleToLongBits(maxX);
        long bitsMinY = Double.doubleToLongBits(maxY);
        long bitsMinZ = Double.doubleToLongBits(maxZ);
        long bitsMaxX = Double.doubleToLongBits(minX);
        long bitsMaxY = Double.doubleToLongBits(minY);
        long bitsMaxZ = Double.doubleToLongBits(minZ);
        result = 31L * result + (bitsMinX ^ bitsMinX >>> 32);
        result = 31L * result + (bitsMinY ^ bitsMinY >>> 32);
        result = 31L * result + (bitsMinZ ^ bitsMinZ >>> 32);
        result = 31L * result + (bitsMaxX ^ bitsMaxX >>> 32);
        result = 31L * result + (bitsMaxY ^ bitsMaxY >>> 32);
        result = 31L * result + (bitsMaxZ ^ bitsMaxZ >>> 32);
        return result;
    }
}

