/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.world.storage;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PoiManager.class})
public class PointOfInterestStorageMixin {
    @Unique
    private PoiManager instance() {
        return (PoiManager)this;
    }

    @Inject(method={"getInSquare(Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/stream/Stream;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getInSquare(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Stream<PoiRecord>> cir) {
        cir.setReturnValue((Object)SepalsPointOfInterestStorage.getInSquare(this.instance(), typePredicate, pos, radius, occupationStatus).stream());
    }

    @Inject(method={"getInChunk(Ljava/util/function/Predicate;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/stream/Stream;"}, at={@At(value="HEAD")}, cancellable=true)
    @VisibleForDebug
    public void getInChunk(Predicate<Holder<PoiType>> typePredicate, ChunkPos chunkPos, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Stream<PoiRecord>> cir) {
        if (Sepals.isAbleToUseSepalsGetInChunkFunction() || Sepals.CONFIG.isForceEnableSepalsPoi()) {
            cir.setReturnValue(SepalsPointOfInterestStorage.sepalsGetInChunk(this.instance(), typePredicate, chunkPos, occupationStatus));
        }
    }

    @Inject(method={"getInRange(Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/stream/Stream;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getInCircle(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Stream<PoiRecord>> cir) {
        cir.setReturnValue((Object)SepalsPointOfInterestStorage.getInCircle(this.instance(), typePredicate, pos, radius, occupationStatus).stream());
    }

    @Inject(method={"findAll(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/stream/Stream;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getPositions(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Stream<BlockPos>> cir) {
        cir.setReturnValue((Object)SepalsPointOfInterestStorage.getPositions(this.instance(), typePredicate, posPredicate, pos, radius, occupationStatus).stream());
    }

    @Inject(method={"findAllWithType(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/stream/Stream;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTypesAndPositions(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Stream<Pair<Holder<PoiType>, BlockPos>>> cir) {
        cir.setReturnValue((Object)SepalsPointOfInterestStorage.getTypesAndPositions(this.instance(), typePredicate, posPredicate, pos, radius, occupationStatus).stream());
    }

    @Inject(method={"findAllWithType(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/stream/Stream;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSortedTypesAndPositions(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Stream<Pair<Holder<PoiType>, BlockPos>>> cir) {
        cir.setReturnValue((Object)SepalsPointOfInterestStorage.getSortedTypesAndPositions(this.instance(), typePredicate, posPredicate, pos, radius, occupationStatus).stream());
    }

    @Inject(method={"find(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getPosition(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        cir.setReturnValue(SepalsPointOfInterestStorage.getPosition(this.instance(), typePredicate, posPredicate, pos, radius, occupationStatus));
    }

    @Inject(method={"findClosest(Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getNearestPosition(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        cir.setReturnValue(SepalsPointOfInterestStorage.getNearestPosition(this.instance(), typePredicate, pos, radius, occupationStatus));
    }

    @Inject(method={"findClosestWithType(Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getNearestTypeAndPosition(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Optional<Pair<Holder<PoiType>, BlockPos>>> cir) {
        cir.setReturnValue(SepalsPointOfInterestStorage.getNearestTypeAndPosition(this.instance(), typePredicate, pos, radius, occupationStatus));
    }

    @Inject(method={"findClosest(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getNearestPosition(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        cir.setReturnValue(SepalsPointOfInterestStorage.getNearestPosition(this.instance(), typePredicate, posPredicate, pos, radius, occupationStatus));
    }

    @Inject(method={"take(Ljava/util/function/Predicate;Ljava/util/function/BiPredicate;Lnet/minecraft/core/BlockPos;I)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getPosition(Predicate<Holder<PoiType>> typePredicate, BiPredicate<Holder<PoiType>, BlockPos> biPredicate, BlockPos pos, int radius, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        cir.setReturnValue(SepalsPointOfInterestStorage.getPosition(this.instance(), typePredicate, biPredicate, pos, radius));
    }

    @Inject(method={"getRandom(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/world/entity/ai/village/poi/PoiManager$Occupancy;Lnet/minecraft/core/BlockPos;ILnet/minecraft/util/RandomSource;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getPosition(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, PoiManager.Occupancy occupationStatus, BlockPos pos, int radius, RandomSource random, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        cir.setReturnValue(SepalsPointOfInterestStorage.getPosition(this.instance(), typePredicate, posPredicate, occupationStatus, pos, radius, random));
    }

    @Inject(method={"ensureLoadedAndValid(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void preloadChunks(LevelReader world, BlockPos pos, int radius, CallbackInfo ci) {
        SepalsPointOfInterestStorage.preloadChunks(this.instance(), world, pos, radius);
        ci.cancel();
    }
}

