/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.weight;

import com.github.cao.awa.catheter.Catheter;
import java.util.Comparator;
import net.minecraft.util.RandomSource;

public class WeightedList<U> {
    protected final Catheter<Entry<U>> entries = Catheter.make((Object[])new Entry[0]);
    protected Catheter<U> elements = Catheter.make((Object[])new Object[0]);

    public int size() {
        return this.entries.count();
    }

    public WeightedList<U> add(U data, int weight) {
        this.entries.append((Object[])new Entry[]{new Entry<U>(data, weight)});
        this.varyElements();
        return this;
    }

    public WeightedList<U> shuffle() {
        this.entries.sort(Comparator.comparingDouble(Entry::getShuffledOrder));
        this.elements = this.entries.varyTo(Entry::getElement);
        return this;
    }

    private void varyElements() {
        this.elements = this.entries.varyTo(Entry::getElement);
    }

    public Catheter<U> elements() {
        return this.elements.dump();
    }

    public String toString() {
        return "ShufflingList[" + String.valueOf(this.entries) + "]";
    }

    public static class Entry<T> {
        private static final RandomSource random = RandomSource.create();
        final T data;
        final int weight;

        Entry(T data, int weight) {
            this.weight = weight;
            this.data = data;
        }

        private double getShuffledOrder() {
            return -Math.pow(random.nextFloat(), 1.0f / (float)this.weight);
        }

        public T getElement() {
            return this.data;
        }

        public int getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.weight + ":" + String.valueOf(this.data);
        }
    }
}

