/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.catheter;

import com.github.cao.awa.catheter.BooleanCatheter;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.catheter.DoubleCatheter;
import com.github.cao.awa.catheter.IntCatheter;
import com.github.cao.awa.catheter.LongCatheter;
import com.github.cao.awa.catheter.action.BiBytePredicate;
import com.github.cao.awa.catheter.action.BiByteToByteFunction;
import com.github.cao.awa.catheter.action.BooleanConsumer;
import com.github.cao.awa.catheter.action.ByteConsumer;
import com.github.cao.awa.catheter.action.ByteFunction;
import com.github.cao.awa.catheter.action.BytePredicate;
import com.github.cao.awa.catheter.action.ByteToDoubleFunction;
import com.github.cao.awa.catheter.action.ByteToIntegerFunction;
import com.github.cao.awa.catheter.action.ByteToLongFunction;
import com.github.cao.awa.catheter.action.ByteUnaryOperator;
import com.github.cao.awa.catheter.action.IntegerAndBiBytePredicate;
import com.github.cao.awa.catheter.action.IntegerAndBiByteToByteFunction;
import com.github.cao.awa.catheter.action.IntegerAndByteConsumer;
import com.github.cao.awa.catheter.action.IntegerAndBytePredicate;
import com.github.cao.awa.catheter.matrix.MatrixFlockPos;
import com.github.cao.awa.catheter.matrix.MatrixPos;
import com.github.cao.awa.catheter.pair.IntegerAndBytePair;
import com.github.cao.awa.catheter.receptacle.BooleanReceptacle;
import com.github.cao.awa.catheter.receptacle.ByteReceptacle;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.sinuatum.function.QuinFunction;
import com.github.cao.awa.sinuatum.function.TriFunction;
import com.github.cao.awa.sinuatum.function.consumer.TriConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;

public class ByteCatheter {
    private static final Random RANDOM = new Random();
    private byte[] targets;

    public ByteCatheter(byte[] targets) {
        this.targets = targets;
    }

    public static ByteCatheter make(byte ... targets) {
        return new ByteCatheter(targets);
    }

    public static ByteCatheter makeCapacity(int size) {
        return new ByteCatheter(ByteCatheter.array(size));
    }

    public static <X> ByteCatheter of(byte[] targets) {
        return new ByteCatheter(targets);
    }

    public static ByteCatheter of(Collection<Byte> targets) {
        if (targets == null) {
            return new ByteCatheter(ByteCatheter.array(0));
        }
        byte[] delegate = new byte[targets.size()];
        int index = 0;
        for (byte target : targets) {
            delegate[index++] = target;
        }
        return new ByteCatheter(delegate);
    }

    public ByteCatheter each(ByteConsumer action) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            action.accept(b);
        }
        return this;
    }

    public ByteCatheter each(ByteConsumer action, Runnable poster) {
        this.each(action);
        poster.run();
        return this;
    }

    public <X> ByteCatheter each(X initializer, BiConsumer<X, Byte> action) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            action.accept(initializer, b);
        }
        return this;
    }

    public <X> ByteCatheter each(X initializer, BiConsumer<X, Byte> action, Consumer<X> poster) {
        this.each(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public <X> ByteCatheter overall(X initializer, TriConsumer<X, Integer, Byte> action) {
        byte[] ts = this.targets;
        int index = 0;
        for (byte b : ts) {
            action.accept(initializer, index++, b);
        }
        return this;
    }

    public <X> ByteCatheter overall(X initializer, TriConsumer<X, Integer, Byte> action, Consumer<X> poster) {
        this.overall(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public ByteCatheter overall(IntegerAndByteConsumer action) {
        byte[] ts = this.targets;
        int index = 0;
        for (byte b : ts) {
            action.accept(index++, b);
        }
        return this;
    }

    public ByteCatheter overall(IntegerAndByteConsumer action, Runnable poster) {
        this.overall(action);
        poster.run();
        return this;
    }

    public ByteCatheter insert(IntegerAndBiByteToByteFunction maker) {
        HashMap indexes = new HashMap();
        ByteReceptacle lastItem = ByteReceptacle.of();
        this.overall((index, item) -> {
            indexes.put(index + indexes.size(), new IntegerAndBytePair(index, maker.apply(index, item, lastItem.get())));
            lastItem.set(item);
        });
        byte[] ts = this.targets;
        byte[] newDelegate = ByteCatheter.array(ts.length + indexes.size());
        IntegerReceptacle lastIndex = new IntegerReceptacle(0);
        IntegerReceptacle lastDest = new IntegerReceptacle(0);
        IntCatheter.of(indexes.keySet()).sort().each((int index) -> {
            if (lastIndex.get() != index) {
                int maxCopyLength = Math.min(newDelegate.length - lastDest.get() - 1, index - lastIndex.get());
                System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), maxCopyLength);
            }
            IntegerAndBytePair item = (IntegerAndBytePair)indexes.get(index);
            newDelegate[index] = item.byteValue();
            lastIndex.set(item.intValue());
            lastDest.set(index + 1);
        }, () -> System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), newDelegate.length - lastDest.get()));
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter pluck(IntegerAndBiBytePredicate maker) {
        ByteReceptacle lastItem = ByteReceptacle.of();
        return this.overallFilter((index, item) -> {
            if (maker.test(index, item, lastItem.get())) {
                return false;
            }
            lastItem.set(item);
            return true;
        });
    }

    public ByteCatheter discardTo(BytePredicate predicate) {
        ByteCatheter result = ByteCatheter.make(new byte[0]);
        this.overallFilter((index, item) -> !predicate.test(item), result::reset);
        return result;
    }

    public <X> ByteCatheter discardTo(Predicate<X> predicate, ByteFunction<X> converter) {
        ByteCatheter result = ByteCatheter.make(new byte[0]);
        this.overallFilter((index, item) -> !predicate.test(converter.apply(item)), result::reset);
        return result;
    }

    public ByteCatheter discardTo(byte initializer, BiBytePredicate predicate) {
        ByteCatheter result = ByteCatheter.make(new byte[0]);
        this.overallFilter((index, item) -> !predicate.test(item, initializer), result::reset);
        return result;
    }

    public ByteCatheter orDiscardTo(boolean succeed, BytePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate);
    }

    public <X> ByteCatheter orDiscardTo(boolean succeed, Predicate<X> predicate, ByteFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate, converter);
    }

    public ByteCatheter orDiscardTo(boolean succeed, byte initializer, BiBytePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(initializer, predicate);
    }

    public ByteCatheter discard(BytePredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item));
    }

    public <X> ByteCatheter discard(Predicate<X> predicate, ByteFunction<X> converter) {
        return this.overallFilter((index, item) -> !predicate.test(converter.apply(item)));
    }

    public ByteCatheter discard(byte initializer, BiBytePredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item, initializer));
    }

    public ByteCatheter orDiscard(boolean succeed, BytePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate);
    }

    public <X> ByteCatheter orDiscard(boolean succeed, Predicate<X> predicate, ByteFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate, converter);
    }

    public ByteCatheter orDiscard(boolean succeed, byte initializer, BiBytePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(initializer, predicate);
    }

    public ByteCatheter filterTo(BytePredicate predicate) {
        return this.dump().filter(predicate);
    }

    public <X> ByteCatheter filterTo(Predicate<X> predicate, ByteFunction<X> converter) {
        return this.dump().filter(predicate, converter);
    }

    public ByteCatheter filterTo(byte initializer, BiBytePredicate predicate) {
        return this.dump().filter(initializer, predicate);
    }

    public ByteCatheter orFilterTo(boolean succeed, BytePredicate predicate) {
        return this.dump().orFilter(succeed, predicate);
    }

    public <X> ByteCatheter orFilterTo(boolean succeed, Predicate<X> predicate, ByteFunction<X> converter) {
        return this.dump().orFilter(succeed, predicate, converter);
    }

    public ByteCatheter orFilterTo(boolean succeed, byte initializer, BiBytePredicate predicate) {
        return this.dump().orFilter(succeed, initializer, predicate);
    }

    public ByteCatheter filter(BytePredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item));
    }

    public <X> ByteCatheter filter(Predicate<X> predicate, ByteFunction<X> converter) {
        return this.overallFilter((index, item) -> predicate.test(converter.apply(item)));
    }

    public ByteCatheter overallFilter(IntegerAndBytePredicate predicate) {
        return this.overallFilter(predicate, (byte[] x) -> {});
    }

    public ByteCatheter overallFilter(IntegerAndBytePredicate predicate, Consumer<byte[]> discarding) {
        if (this.isEmpty()) {
            return this;
        }
        byte[] ts = this.targets;
        int length = ts.length;
        boolean[] deleting = new boolean[length];
        int newDelegateSize = length;
        int index = 0;
        for (byte target : ts) {
            if (predicate.test(index, target)) {
                ++index;
                continue;
            }
            deleting[index++] = true;
            --newDelegateSize;
        }
        byte[] newDelegate = ByteCatheter.array(newDelegateSize);
        byte[] discardingDelegate = ByteCatheter.array(length - newDelegateSize);
        int discardingDelegateIndex = 0;
        int newDelegateIndex = 0;
        index = 0;
        for (boolean isDeleting : deleting) {
            byte t = ts[index++];
            if (isDeleting) {
                discardingDelegate[discardingDelegateIndex++] = t;
                continue;
            }
            newDelegate[newDelegateIndex++] = t;
        }
        discarding.accept(discardingDelegate);
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter overallFilter(byte initializer, IntegerAndBiBytePredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(index, item, initializer));
    }

    public ByteCatheter filter(byte initializer, BiBytePredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item, initializer));
    }

    public ByteCatheter orFilter(boolean succeed, BytePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate);
    }

    public <X> ByteCatheter orFilter(boolean succeed, Predicate<X> predicate, ByteFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate, converter);
    }

    public ByteCatheter orFilter(boolean succeed, byte initializer, BiBytePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(initializer, predicate);
    }

    public ByteCatheter distinct() {
        HashMap map = new HashMap();
        return this.filter(item -> {
            if (map.getOrDefault(item, false).booleanValue()) {
                return false;
            }
            map.put(item, true);
            return true;
        });
    }

    public ByteCatheter removeWithIndex(int index) {
        if (this.isEmpty() || index >= this.count() || index < 0) {
            return this;
        }
        byte[] newDelegate = ByteCatheter.array(this.count() - 1);
        if (index > 0) {
            System.arraycopy(this.targets, 0, newDelegate, 0, index);
        }
        System.arraycopy(this.targets, index + 1, newDelegate, index, this.count() - 1 - index);
        this.targets = newDelegate;
        return this;
    }

    public boolean isPresent() {
        return this.count() > 0;
    }

    public ByteCatheter ifPresent(Consumer<ByteCatheter> action) {
        if (this.count() > 0) {
            action.accept(this);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public ByteCatheter ifEmpty(Consumer<ByteCatheter> action) {
        if (this.count() == 0) {
            action.accept(this);
        }
        return this;
    }

    public ByteCatheter sort() {
        Arrays.sort(this.targets);
        return this;
    }

    public ByteCatheter sort(Comparator<Byte> comparator) {
        Byte[] array = new Byte[this.targets.length];
        int index = 0;
        for (byte target : this.targets) {
            array[index++] = target;
        }
        Arrays.sort(array, comparator);
        index = 0;
        Byte[] byteArray = array;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte target;
            target = byteArray[i];
            this.targets[index++] = target;
        }
        return this;
    }

    public ByteCatheter holdTill(int index) {
        if (this.isEmpty()) {
            return this;
        }
        index = Math.min(index, this.targets.length);
        byte[] ts = this.targets;
        byte[] newDelegate = ByteCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter holdTill(BytePredicate predicate) {
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        byte[] ts = this.targets;
        byte[] newDelegate = ByteCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter whenFlock(byte source, BiByteToByteFunction maker, ByteConsumer consumer) {
        consumer.accept(this.flock(source, maker));
        return this;
    }

    public ByteCatheter whenFlock(BiByteToByteFunction maker, ByteConsumer consumer) {
        consumer.accept(this.flock(maker));
        return this;
    }

    public byte flock(byte source, BiByteToByteFunction maker) {
        byte[] ts = this.targets;
        byte result = source;
        for (byte b : ts) {
            result = maker.applyAsByte(result, b);
        }
        return result;
    }

    public byte flock(BiByteToByteFunction maker) {
        byte[] ts = this.targets;
        int length = ts.length;
        byte result = length > 0 ? ts[0] : (byte)0;
        for (int i = 1; i < length; ++i) {
            result = maker.applyAsByte(result, ts[i]);
        }
        return result;
    }

    public <X> X alternate(X source, BiFunction<X, Byte, X> maker) {
        byte[] ts;
        X result = source;
        for (byte b : ts = this.targets) {
            result = maker.apply(result, b);
        }
        return result;
    }

    public <X> ByteCatheter whenAlternate(X source, BiFunction<X, Byte, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public <X> ByteCatheter whenAlternate(BiFunction<X, Byte, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(null, maker));
        return this;
    }

    public boolean alternate(boolean source, BiBytePredicate maker) {
        BooleanReceptacle result = new BooleanReceptacle(source);
        this.flock((older, newer) -> {
            result.and(maker.test(older, newer));
            return newer;
        });
        return result.get();
    }

    public ByteCatheter whenAlternate(boolean source, BiBytePredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public ByteCatheter whenAlternate(BiBytePredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(false, maker));
        return this;
    }

    public ByteCatheter waiveTill(int index) {
        byte[] newDelegate;
        if (this.isEmpty()) {
            return this;
        }
        byte[] ts = this.targets;
        if (index >= ts.length) {
            newDelegate = ByteCatheter.array(0);
        } else {
            newDelegate = ByteCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter waiveTill(BytePredicate predicate) {
        byte[] newDelegate;
        byte[] ts;
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        if (index >= (ts = this.targets).length) {
            newDelegate = ByteCatheter.array(0);
        } else {
            newDelegate = ByteCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter till(BytePredicate predicate) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (predicate.test(b)) break;
        }
        return this;
    }

    public int findTill(BytePredicate predicate) {
        byte[] ts = this.targets;
        int index = 0;
        for (byte b : ts) {
            if (predicate.test(b)) break;
            ++index;
        }
        return index;
    }

    public ByteCatheter replace(ByteUnaryOperator handler) {
        if (this.isEmpty()) {
            return this;
        }
        byte[] ts = this.targets;
        int index = 0;
        for (byte b : ts) {
            ts[index++] = handler.applyAsByte(b);
        }
        return this;
    }

    public BooleanCatheter vary(BytePredicate handler) {
        if (this.isEmpty()) {
            return BooleanCatheter.make(new boolean[0]);
        }
        byte[] ts = this.targets;
        boolean[] array = new boolean[ts.length];
        int index = 0;
        for (byte i : ts) {
            array[index++] = handler.test(i);
        }
        return BooleanCatheter.of(array);
    }

    public DoubleCatheter vary(ByteToDoubleFunction handler) {
        if (this.isEmpty()) {
            return DoubleCatheter.make(new double[0]);
        }
        byte[] ts = this.targets;
        double[] array = new double[ts.length];
        int index = 0;
        for (byte i : ts) {
            array[index++] = handler.applyAsDouble(i);
        }
        return DoubleCatheter.of(array);
    }

    public ByteCatheter vary(ByteUnaryOperator handler) {
        return this.replace(handler);
    }

    public LongCatheter vary(ByteToLongFunction handler) {
        if (this.isEmpty()) {
            return LongCatheter.make(new long[0]);
        }
        byte[] ts = this.targets;
        long[] array = new long[ts.length];
        int index = 0;
        for (byte i : ts) {
            array[index++] = handler.applyAsLong(i);
        }
        return LongCatheter.of(array);
    }

    public IntCatheter vary(ByteToIntegerFunction handler) {
        if (this.isEmpty()) {
            return IntCatheter.make(new int[0]);
        }
        byte[] ts = this.targets;
        int[] array = new int[ts.length];
        int index = 0;
        for (byte i : ts) {
            array[index++] = handler.applyAsInteger(i);
        }
        return IntCatheter.of(array);
    }

    public <X> Catheter<X> vary(ByteFunction<X> handler) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        byte[] ts = this.targets;
        X[] array = ByteCatheter.xArray(ts.length);
        int index = 0;
        for (byte b : ts) {
            array[index++] = handler.apply(b);
        }
        return Catheter.of(array);
    }

    public <X> Catheter<X> vary(ByteFunction<X> handler, IntFunction<X[]> arrayGenerator) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        byte[] ts = this.targets;
        X[] array = arrayGenerator.apply(ts.length);
        int index = 0;
        for (byte l : ts) {
            array[index++] = handler.apply(l);
        }
        return Catheter.of(array).arrayGenerator(arrayGenerator);
    }

    public ByteCatheter whenAny(BytePredicate predicate, ByteConsumer action) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            action.accept(b);
            break;
        }
        return this;
    }

    public ByteCatheter whenAll(BytePredicate predicate, Runnable action) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (predicate.test(b)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public ByteCatheter whenAll(BytePredicate predicate, ByteConsumer action) {
        return this.whenAll(predicate, () -> this.each(action));
    }

    private ByteCatheter whenNone(BytePredicate predicate, Runnable action) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public boolean hasAny(BytePredicate predicate) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(BytePredicate predicate) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (predicate.test(b)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNone(BytePredicate predicate) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return false;
        }
        return true;
    }

    public byte findFirst(BytePredicate predicate) {
        byte[] ts;
        for (byte b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return b;
        }
        return 0;
    }

    public byte findLast(BytePredicate predicate) {
        byte[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            byte t;
            if (!predicate.test(t = ts[index--])) continue;
            return t;
        }
        return 0;
    }

    public <X> X whenFoundFirst(BytePredicate predicate, ByteFunction<X> function) {
        byte[] ts = this.targets;
        int length = ts.length;
        boolean index = false;
        for (byte b : ts) {
            if (!predicate.test(b)) continue;
            return function.apply(b);
        }
        return null;
    }

    public <X> X whenFoundLast(BytePredicate predicate, ByteFunction<X> function) {
        byte[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            byte t;
            if (!predicate.test(t = ts[index--])) continue;
            return function.apply(t);
        }
        return null;
    }

    public ByteCatheter any(ByteConsumer consumer) {
        if (this.targets.length > 0) {
            byte[] ls = this.targets;
            int index = RANDOM.nextInt(ls.length);
            consumer.accept(ls.length > index ? ls[index] : ls[ls.length - 1]);
        }
        return this;
    }

    public ByteCatheter first(ByteConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[0]);
        }
        return this;
    }

    public ByteCatheter tail(ByteConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[this.targets.length - 1]);
        }
        return this;
    }

    public ByteCatheter reverse() {
        if (this.isEmpty()) {
            return this;
        }
        byte[] ts = this.targets;
        int length = ts.length;
        int split = length / 2;
        for (int index = 0; index < split; ++index) {
            int swapIndex = length - index - 1;
            byte temp = ts[index];
            ts[index] = ts[swapIndex];
            ts[swapIndex] = temp;
        }
        return this;
    }

    public byte max(Comparator<Byte> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
    }

    public byte min(Comparator<Byte> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
    }

    public ByteCatheter whenMax(Comparator<Byte> comparator, ByteConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result));
        return this;
    }

    public ByteCatheter whenMin(Comparator<Byte> comparator, ByteConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result));
        return this;
    }

    public int count() {
        return this.targets.length;
    }

    public ByteCatheter count(AtomicInteger target) {
        target.set(this.count());
        return this;
    }

    public ByteCatheter count(IntegerReceptacle target) {
        target.set(this.count());
        return this;
    }

    public ByteCatheter count(Consumer<Integer> consumer) {
        consumer.accept(this.count());
        return this;
    }

    public final ByteCatheter append(byte ... objects) {
        byte[] ts = this.targets;
        byte[] newDelegate = ByteCatheter.array(ts.length + objects.length);
        System.arraycopy(ts, 0, newDelegate, 0, ts.length);
        System.arraycopy(objects, 0, newDelegate, ts.length, objects.length);
        this.targets = newDelegate;
        return this;
    }

    public ByteCatheter append(ByteCatheter objects) {
        return this.append(objects.array());
    }

    public ByteCatheter repeat(int count) {
        byte[] ts = this.array();
        for (int i = 0; i < count; ++i) {
            this.append(ts);
        }
        return this;
    }

    public byte fetch(int index) {
        return this.targets[Math.min(index, this.targets.length - 1)];
    }

    public void fetch(int index, byte item) {
        this.targets[index] = item;
    }

    public ByteCatheter matrixEach(int width, BiConsumer<MatrixPos, Byte> action) {
        return this.matrixReplace(width, (pos, item) -> {
            action.accept((MatrixPos)pos, (Byte)item);
            return item;
        });
    }

    public <X> Catheter<X> matrixHomoVary(int width, ByteCatheter input, TriFunction<MatrixPos, Byte, Byte, X> action) {
        if (input.count() == this.count()) {
            IntegerReceptacle index = new IntegerReceptacle(0);
            return this.matrixVary(width, (pos, item) -> {
                int indexValue = index.get();
                byte inputX = input.fetch(indexValue);
                Object result = action.apply((MatrixPos)pos, (Byte)item, inputX);
                index.set(indexValue + 1);
                return result;
            });
        }
        throw new IllegalArgumentException("The matrix is not homogeneous matrix");
    }

    public ByteCatheter matrixMap(int width, int inputWidth, ByteCatheter input, QuinFunction<MatrixFlockPos, MatrixPos, MatrixPos, Byte, Byte, Byte> scanFlocked, TriFunction<MatrixPos, Byte, Byte, Byte> combineFlocked) {
        int sourceHeight;
        boolean homoMatrix;
        int inputHeight = input.count() / inputWidth;
        boolean bl = homoMatrix = inputHeight == (sourceHeight = this.count() / width) && width == inputWidth;
        if (width != inputHeight && !homoMatrix) {
            throw new IllegalArgumentException("The matrix cannot be constructed because input height does not match to source width");
        }
        ByteCatheter newMatrix = ByteCatheter.makeCapacity(homoMatrix ? sourceHeight * width : sourceHeight * inputWidth);
        ByteCatheter flockingCatheter = ByteCatheter.makeCapacity(width);
        return newMatrix.matrixReplace(inputWidth, (pos, ignored) -> {
            int posX = pos.x();
            int posY = pos.y();
            int flockingIndex = 0;
            int inputY = 0;
            for (int sourceX = 0; sourceX < width; ++sourceX) {
                MatrixFlockPos flockPos = new MatrixFlockPos(posX, posY);
                MatrixPos inputPos = new MatrixPos(posX, inputY);
                MatrixPos sourcePos = new MatrixPos(sourceX, posY);
                byte fetchedSource = this.fetch(posY * width + sourceX);
                byte fetchedInput = input.fetch(inputY * inputWidth + posX);
                flockingCatheter.fetch(flockingIndex++, (Byte)scanFlocked.apply(flockPos, sourcePos, inputPos, fetchedSource, fetchedInput));
                ++inputY;
            }
            return flockingCatheter.flock((current, next) -> (Byte)combineFlocked.apply((MatrixPos)pos, current, next));
        });
    }

    public <X> Catheter<X> matrixVary(int width, byte input, TriFunction<MatrixPos, Byte, Byte, X> action) {
        return this.matrixVary(width, (pos, item) -> action.apply((MatrixPos)pos, (Byte)item, input));
    }

    public ByteCatheter matrixReplace(int width, BiFunction<MatrixPos, Byte, Byte> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.replace(item -> {
            int wValue = w.get();
            int hValue = h.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return (Byte)action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public <X> Catheter<X> matrixVary(int width, BiFunction<MatrixPos, Byte, X> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.vary((byte item) -> {
            int hValue = h.get();
            int wValue = w.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public Catheter<ByteCatheter> matrixLines(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int sourceHeight = this.count() / width;
        Catheter<ByteCatheter> results = Catheter.makeCapacity(sourceHeight);
        ByteCatheter catheter = ByteCatheter.makeCapacity(width);
        for (int y = 0; y < sourceHeight; ++y) {
            for (int x = 0; x < width; ++x) {
                byte element = this.fetch(y * width + x);
                catheter.fetch(x, element);
            }
            results.fetch(y, catheter.dump());
        }
        return results;
    }

    public ByteCatheter shuffle() {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public ByteCatheter shuffle(RandomGenerator random) {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public ByteCatheter swapShuffle(RandomGenerator random) {
        int i;
        byte[] elements = this.targets;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            byte fromElement = elements[swapFrom];
            byte toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
        return this;
    }

    public boolean has(byte target) {
        return this.hasAny(t -> t == target);
    }

    public boolean not(byte target) {
        return !this.has(target);
    }

    public ByteCatheter merge(ByteCatheter other) {
        return this.append(other.filter(this::not));
    }

    public ByteCatheter dump() {
        return new ByteCatheter(this.array());
    }

    public ByteCatheter flat(ByteFunction<ByteCatheter> function) {
        if (this.isEmpty()) {
            return this;
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (byte element : this.targets) {
            ByteCatheter flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        this.targets = ByteCatheter.array(totalSize);
        int pos = 0;
        for (ByteCatheter flat : (ByteCatheter[])catheter.targets) {
            System.arraycopy(flat.targets, 0, this.targets, pos, flat.targets.length);
            pos += flat.targets.length;
        }
        return this;
    }

    public <X> Catheter<X> flatTo(ByteFunction<Catheter<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (byte element : this.targets) {
            Catheter<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        return Catheter.flatting(catheter, totalSize);
    }

    public <X> Catheter<X> flatToByCollection(ByteFunction<Collection<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (byte element : this.targets) {
            Collection<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.size();
        }
        return Catheter.flattingCollection(catheter, totalSize);
    }

    public ByteCatheter reset() {
        this.targets = ByteCatheter.array(0);
        return this;
    }

    public ByteCatheter reset(byte[] targets) {
        this.targets = targets;
        return this;
    }

    public byte[] array() {
        return (byte[])this.targets.clone();
    }

    public byte[] dArray() {
        return this.targets;
    }

    public Stream<Byte> stream() {
        return this.list().stream();
    }

    public List<Byte> list() {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte l : this.array()) {
            list.add(l);
        }
        return list;
    }

    public Set<Byte> set() {
        HashSet<Byte> set = new HashSet<Byte>();
        for (byte l : this.array()) {
            set.add(l);
        }
        return set;
    }

    private static byte[] array(int size) {
        return new byte[size];
    }

    private static <X> X[] xArray(int size) {
        return new Object[size];
    }
}

