/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.config;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.config.key.SepalsConfigKey;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SepalsConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"SepalsConfig");
    private static final File CONFIG_FILE = new File("config/sepals.json");
    public static final SepalsConfigKey FORCE_ENABLE_SEPALS_POI = SepalsConfigKey.create("forceEnableSepalsPoi", false, enabled -> {
        if (enabled) {
            SepalsPointOfInterestStorage.onRequiredSepalsGetInChunk();
        }
    });
    public static final SepalsConfigKey ENABLE_SEPALS_VILLAGER = SepalsConfigKey.create("enableSepalsVillager", true);
    public static final SepalsConfigKey ENABLE_SEPALS_FROG_LOOK_AT = SepalsConfigKey.create("enableSepalsFrogLookAt", true);
    public static final SepalsConfigKey ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR = SepalsConfigKey.create("enableSepalsFrogAttackableSensor", true);
    public static final SepalsConfigKey ENABLE_SEPALS_LIVING_TARGET_CACHE = SepalsConfigKey.create("enableSepalsLivingTargetCache", true);
    public static final SepalsConfigKey NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT = SepalsConfigKey.create("nearestLivingEntitiesSensorUseQuickSort", true);
    public static final SepalsConfigKey ENABLE_SEPALS_BIASED_LONG_JUMP_TASK = SepalsConfigKey.create("enableSepalsBiasedLongJumpTask", true);
    public static final SepalsConfigKey ENABLE_SEPALS_ENTITIES_CRAMMING = SepalsConfigKey.create("enableSepalsEntitiesCramming", true);
    public static final SepalsConfigKey ENABLE_SEPALS_ITEM_MERGE = SepalsConfigKey.create("enableSepalsItemMerge", true);
    public static final SepalsConfigKey ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE = SepalsConfigKey.create("enableSepalsQuickCanBePushByEntityPredicate", true);
    public static final SepalsConfigKey ENABLE_SEPALS_REGISTRY_PROBE = SepalsConfigKey.create("enableSepalsRegistryProbe", true);
    private final Map<String, Boolean> config = new Object2BooleanArrayMap();

    public boolean isForceEnableSepalsPoi() {
        return this.getConfig(FORCE_ENABLE_SEPALS_POI);
    }

    public boolean isEnableSepalsVillager() {
        return this.getConfig(ENABLE_SEPALS_VILLAGER);
    }

    public boolean isEnableSepalsFrogLookAt() {
        return this.getConfig(ENABLE_SEPALS_FROG_LOOK_AT);
    }

    public boolean isEnableSepalsFrogAttackableSensor() {
        return this.getConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR);
    }

    public boolean isEnableSepalsLivingTargetCache() {
        return this.getConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE);
    }

    public boolean isNearestLivingEntitiesSensorUseQuickSort() {
        return this.getConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT);
    }

    public boolean isEnableSepalsBiasedLongJumpTask() {
        return this.getConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK);
    }

    public boolean isEnableSepalsEntitiesCramming() {
        return this.getConfig(ENABLE_SEPALS_ENTITIES_CRAMMING);
    }

    public boolean isEnableSepalsItemMerge() {
        return this.getConfig(ENABLE_SEPALS_ITEM_MERGE);
    }

    public boolean isEnableSepalsQuickCanBePushByEntityPredicate() {
        return this.getConfig(ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE);
    }

    public boolean isEnableSepalsRegistryProbe() {
        return this.getConfig(ENABLE_SEPALS_REGISTRY_PROBE);
    }

    public void setConfig(SepalsConfigKey configKey, boolean value) {
        this.config.put(configKey.name(), value);
    }

    public void setConfig(SepalsConfigKey configKey, Map<String, Boolean> map) {
        this.config.put(configKey.name(), this.getOrDefault(configKey, map));
    }

    private boolean getOrDefault(SepalsConfigKey configKey, Map<String, Boolean> map) {
        Boolean result = map.get(configKey.name());
        if (result == null) {
            return configKey.value();
        }
        return result;
    }

    public boolean getConfig(@NotNull SepalsConfigKey configKey) {
        Boolean value = this.config.get(configKey.name());
        if (value == null) {
            return configKey.value();
        }
        return value;
    }

    public void load() {
        this.loadAsDefault();
        try {
            Map<String, Boolean> config = this.toMap(IOUtil.read(new FileReader(CONFIG_FILE, StandardCharsets.UTF_8)));
            this.setConfig(FORCE_ENABLE_SEPALS_POI, config);
            this.setConfig(ENABLE_SEPALS_VILLAGER, config);
            this.setConfig(ENABLE_SEPALS_FROG_LOOK_AT, config);
            this.setConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR, config);
            this.setConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE, config);
            this.setConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT, config);
            this.setConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK, config);
            this.setConfig(ENABLE_SEPALS_ENTITIES_CRAMMING, config);
            this.setConfig(ENABLE_SEPALS_ITEM_MERGE, config);
            this.setConfig(ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE, config);
            this.setConfig(ENABLE_SEPALS_REGISTRY_PROBE, config);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Config not found, will use default config values");
        }
        catch (Exception e) {
            LOGGER.warn("Happening unexpected exception, config system cannot resolve it, will use default config values", (Throwable)e);
        }
        this.write();
    }

    public SepalsConfigKey getConfigKey(String name) {
        return switch (name) {
            case "forceEnableSepalsPoi" -> FORCE_ENABLE_SEPALS_POI;
            case "enableSepalsVillager" -> ENABLE_SEPALS_VILLAGER;
            case "enableSepalsFrogLookAt" -> ENABLE_SEPALS_FROG_LOOK_AT;
            case "enableSepalsFrogAttackableSensor" -> ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR;
            case "enableSepalsLivingTargetCache" -> ENABLE_SEPALS_LIVING_TARGET_CACHE;
            case "nearestLivingEntitiesSensorUseQuickSort" -> NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT;
            case "enableSepalsBiasedLongJumpTask" -> ENABLE_SEPALS_BIASED_LONG_JUMP_TASK;
            case "enableSepalsEntitiesCramming" -> ENABLE_SEPALS_ENTITIES_CRAMMING;
            case "enableSepalsItemMerge" -> ENABLE_SEPALS_ITEM_MERGE;
            case "enableSepalsQuickCanBePushByEntityPredicate" -> ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE;
            case "enableSepalsRegistryProbe" -> ENABLE_SEPALS_REGISTRY_PROBE;
            default -> throw new IllegalArgumentException("Unable to find config key: " + name);
        };
    }

    public Map<String, Boolean> toMap(String data) {
        Map jsonMap = class_3518.method_15285((String)data).asMap();
        Object2ObjectOpenHashMap sepalsMap = new Object2ObjectOpenHashMap();
        return Catheter.of(jsonMap.entrySet()).varyMap(sepalsMap, (identity, entry) -> identity.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean()));
    }

    public void write() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            JsonObject json = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.config.entrySet()) {
                json.addProperty(entry.getKey(), entry.getValue());
            }
            IOUtil.write((Writer)new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8), json.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public void loadAsDefault() {
        this.setConfig(FORCE_ENABLE_SEPALS_POI, FORCE_ENABLE_SEPALS_POI.value());
        this.setConfig(ENABLE_SEPALS_VILLAGER, ENABLE_SEPALS_VILLAGER.value());
        this.setConfig(ENABLE_SEPALS_FROG_LOOK_AT, ENABLE_SEPALS_FROG_LOOK_AT.value());
        this.setConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR, ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR.value());
        this.setConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE, ENABLE_SEPALS_LIVING_TARGET_CACHE.value());
        this.setConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT, NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT.value());
        this.setConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK, ENABLE_SEPALS_BIASED_LONG_JUMP_TASK.value());
        this.setConfig(ENABLE_SEPALS_ENTITIES_CRAMMING, ENABLE_SEPALS_ENTITIES_CRAMMING.value());
        this.setConfig(ENABLE_SEPALS_ITEM_MERGE, ENABLE_SEPALS_ITEM_MERGE.value());
        this.setConfig(ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE, ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE.value());
        this.setConfig(ENABLE_SEPALS_REGISTRY_PROBE, ENABLE_SEPALS_REGISTRY_PROBE.value());
    }

    public void copyFrom(@NotNull SepalsConfig config) {
        this.setConfig(FORCE_ENABLE_SEPALS_POI, config.isForceEnableSepalsPoi());
        this.setConfig(ENABLE_SEPALS_VILLAGER, config.isEnableSepalsVillager());
        this.setConfig(ENABLE_SEPALS_FROG_LOOK_AT, config.isEnableSepalsFrogLookAt());
        this.setConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR, config.isEnableSepalsFrogAttackableSensor());
        this.setConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE, config.isEnableSepalsLivingTargetCache());
        this.setConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT, config.isNearestLivingEntitiesSensorUseQuickSort());
        this.setConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK, config.isEnableSepalsBiasedLongJumpTask());
        this.setConfig(ENABLE_SEPALS_ENTITIES_CRAMMING, config.isEnableSepalsEntitiesCramming());
        this.setConfig(ENABLE_SEPALS_ITEM_MERGE, config.isEnableSepalsItemMerge());
        this.setConfig(ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE, config.isEnableSepalsQuickCanBePushByEntityPredicate());
        this.setConfig(ENABLE_SEPALS_REGISTRY_PROBE, config.isEnableSepalsRegistryProbe());
    }

    public void print() {
        LOGGER.info("Sepals 'forceEnableSepalsPoi' flag is {}", (Object)this.isForceEnableSepalsPoi());
        LOGGER.info("Sepals 'enableSepalsVillager' flag is {}", (Object)this.isEnableSepalsVillager());
        LOGGER.info("Sepals 'enableSepalsFrogLookAt' flag is {}", (Object)this.isEnableSepalsFrogLookAt());
        LOGGER.info("Sepals 'enableSepalsFrogAttackableSensor' flag is {}", (Object)this.isEnableSepalsFrogAttackableSensor());
        LOGGER.info("Sepals 'enableSepalsLivingTargetCache' flag is {}", (Object)this.isEnableSepalsLivingTargetCache());
        LOGGER.info("Sepals 'nearestLivingEntitiesSensorUseQuickSort' flag is {}", (Object)this.isNearestLivingEntitiesSensorUseQuickSort());
        LOGGER.info("Sepals 'enableSepalsBiasedJumpLongTask' flag is {}", (Object)this.isEnableSepalsBiasedLongJumpTask());
        LOGGER.info("Sepals 'enableSepalsEntitiesCramming' flag is {}", (Object)this.isEnableSepalsEntitiesCramming());
        LOGGER.info("Sepals 'enableSepalsItemMerge' flag is {}", (Object)this.isEnableSepalsItemMerge());
        LOGGER.info("Sepals 'enableSepalsQuickCanBePushByEntityPredicate' flag is {}", (Object)this.isEnableSepalsQuickCanBePushByEntityPredicate());
        LOGGER.info("Sepals 'enableSepalsRegistryProbe' flag is {}", (Object)this.isEnableSepalsRegistryProbe());
    }

    public Set<SepalsConfigKey> collect() {
        HashSet<SepalsConfigKey> configs = CollectionFactor.hashSet();
        configs.add(FORCE_ENABLE_SEPALS_POI);
        configs.add(ENABLE_SEPALS_VILLAGER);
        configs.add(ENABLE_SEPALS_FROG_LOOK_AT);
        configs.add(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR);
        configs.add(ENABLE_SEPALS_LIVING_TARGET_CACHE);
        configs.add(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT);
        configs.add(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK);
        configs.add(ENABLE_SEPALS_ENTITIES_CRAMMING);
        configs.add(ENABLE_SEPALS_ITEM_MERGE);
        configs.add(ENABLE_SEPALS_QUICK_CAN_BE_PUSH_BY_ENTITY_PREDICATE);
        configs.add(ENABLE_SEPALS_REGISTRY_PROBE);
        return configs;
    }

    public Set<SepalsConfigKey> collectEnabled() {
        HashSet<SepalsConfigKey> enabled = CollectionFactor.hashSet();
        if (this.isForceEnableSepalsPoi()) {
            enabled.add(FORCE_ENABLE_SEPALS_POI);
        }
        if (this.isEnableSepalsVillager()) {
            enabled.add(ENABLE_SEPALS_VILLAGER);
        }
        if (this.isEnableSepalsFrogLookAt()) {
            enabled.add(ENABLE_SEPALS_FROG_LOOK_AT);
        }
        if (this.isEnableSepalsFrogAttackableSensor()) {
            enabled.add(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR);
        }
        if (this.isEnableSepalsLivingTargetCache()) {
            enabled.add(ENABLE_SEPALS_LIVING_TARGET_CACHE);
        }
        if (this.isNearestLivingEntitiesSensorUseQuickSort()) {
            enabled.add(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT);
        }
        if (this.isEnableSepalsBiasedLongJumpTask()) {
            enabled.add(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK);
        }
        if (this.isEnableSepalsEntitiesCramming()) {
            enabled.add(ENABLE_SEPALS_ENTITIES_CRAMMING);
        }
        if (this.isEnableSepalsItemMerge()) {
            enabled.add(ENABLE_SEPALS_ITEM_MERGE);
        }
        if (this.isEnableSepalsRegistryProbe()) {
            enabled.add(ENABLE_SEPALS_REGISTRY_PROBE);
        }
        return enabled;
    }
}

