/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.poi;

import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public class SepalsFindPointOfInterestTask {
    public static class_7893<class_1314> create(Predicate<class_6880<class_4158>> poiPredicate, class_4140<class_4208> poiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus, BiPredicate<class_3218, class_2338> worldPosBiPredicate) {
        return SepalsFindPointOfInterestTask.create(poiPredicate, poiPosModule, poiPosModule, onlyRunIfChild, entityStatus, worldPosBiPredicate);
    }

    public static class_7893<class_1314> create(Predicate<class_6880<class_4158>> poiPredicate, class_4140<class_4208> poiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus) {
        return SepalsFindPointOfInterestTask.create(poiPredicate, poiPosModule, poiPosModule, onlyRunIfChild, entityStatus, (world, pos) -> true);
    }

    public static class_7893<class_1314> create(Predicate<class_6880<class_4158>> poiPredicate, class_4140<class_4208> poiPosModule, class_4140<class_4208> potentialPoiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus, BiPredicate<class_3218, class_2338> worldPosBiPredicate) {
        MutableLong mutableLong = new MutableLong(0L);
        Long2ObjectOpenHashMap long2ObjectMap = new Long2ObjectOpenHashMap();
        class_7894 singleTickTask = class_7898.method_47224(arg_0 -> SepalsFindPointOfInterestTask.lambda$create$9(potentialPoiPosModule, onlyRunIfChild, mutableLong, (Long2ObjectMap)long2ObjectMap, poiPredicate, entityStatus, arg_0));
        return potentialPoiPosModule == poiPosModule ? singleTickTask : class_7898.method_47224(context -> context.group((App)context.method_47245(poiPosModule)).apply((Applicative)context, poiPos -> singleTickTask));
    }

    @Nullable
    public static class_11 findPathToPoi(class_1308 entity, Pair<class_6880<class_4158>, class_2338>[] pois) {
        if (pois.length == 0) {
            return null;
        }
        HashSet<class_2338> set = new HashSet<class_2338>();
        int i = 1;
        for (Pair<class_6880<class_4158>, class_2338> pair : pois) {
            i = Math.max(i, ((class_4158)((class_6880)pair.getFirst()).comp_349()).comp_817());
            set.add((class_2338)pair.getSecond());
        }
        return entity.method_5942().method_29934(set, i);
    }

    private static /* synthetic */ App lambda$create$9(class_4140 potentialPoiPosModule, boolean onlyRunIfChild, MutableLong mutableLong, Long2ObjectMap long2ObjectMap, Predicate poiPredicate, Optional entityStatus, class_7898.class_7900 taskContext) {
        return taskContext.group((App)taskContext.method_47245(potentialPoiPosModule)).apply((Applicative)taskContext, queryResult -> (world, entity, time) -> {
            if (onlyRunIfChild && entity.method_6109()) {
                return false;
            }
            if (mutableLong.getValue() == 0L) {
                mutableLong.setValue(world.method_8510() + (long)world.field_9229.method_43048(20));
                return false;
            }
            if (world.method_8510() < mutableLong.getValue()) {
                return false;
            }
            mutableLong.setValue(time + 20L + (long)world.method_8409().method_43048(20));
            class_4153 pointOfInterestStorage = world.method_19494();
            long2ObjectMap.long2ObjectEntrySet().removeIf(entry -> !((RetryMarker)entry.getValue()).isAttempting(time));
            Predicate<class_2338> predicate2 = pos -> {
                RetryMarker retryMarker = (RetryMarker)long2ObjectMap.get(pos.method_10063());
                if (retryMarker == null) {
                    return true;
                }
                if (!retryMarker.shouldRetry(time)) {
                    return false;
                }
                retryMarker.setAttemptTime(time);
                return true;
            };
            Pair<class_6880<class_4158>, class_2338>[] set = SepalsPointOfInterestStorage.getSortedTypesAndPositions(pointOfInterestStorage, poiPredicate, predicate2, entity.method_24515(), 48, class_4153.class_4155.field_18487).holdTill(5).distinct().safeArray();
            class_11 path = SepalsFindPointOfInterestTask.findPathToPoi((class_1308)entity, set);
            if (path == null || !path.method_21655()) {
                for (Pair<class_6880<class_4158>, class_2338> pair : set) {
                    long2ObjectMap.computeIfAbsent(((class_2338)pair.getSecond()).method_10063(), m -> new RetryMarker(world.field_9229, time));
                }
            } else {
                class_2338 blockPos = path.method_48();
                pointOfInterestStorage.method_19132(blockPos).ifPresent(poiType -> {
                    SepalsPointOfInterestStorage.getPosition(pointOfInterestStorage, poiPredicate, (registryEntry, blockPos2) -> blockPos2.equals((Object)blockPos), blockPos, 1);
                    queryResult.method_47249((Object)class_4208.method_19443((class_5321)world.method_27983(), (class_2338)blockPos));
                    entityStatus.ifPresent(status -> world.method_8421((class_1297)entity, status.byteValue()));
                    long2ObjectMap.clear();
                    world.method_74535().method_74611(blockPos);
                });
            }
            return true;
        });
    }

    static class RetryMarker {
        private final class_5819 random;
        private long previousAttemptAt;
        private long nextScheduledAttemptAt;
        private int currentDelay;

        RetryMarker(class_5819 random, long time) {
            this.random = random;
            this.setAttemptTime(time);
        }

        public void setAttemptTime(long time) {
            this.previousAttemptAt = time;
            int i = this.currentDelay + this.random.method_43048(40) + 40;
            this.currentDelay = Math.min(i, 400);
            this.nextScheduledAttemptAt = time + (long)this.currentDelay;
        }

        public boolean isAttempting(long time) {
            return time - this.previousAttemptAt < 400L;
        }

        public boolean shouldRetry(long time) {
            return time >= this.nextScheduledAttemptAt;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptAt + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptAt + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

