/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.walk;

import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import com.github.cao.awa.sepals.entity.ai.task.SepalsSingleTickTask;
import com.github.cao.awa.sepals.entity.ai.task.poi.SepalsFindPointOfInterestTask;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class SepalsWalkHomeTask
extends SepalsSingleTickTask<class_1314>
implements DetailedDebuggableTask {
    private final float speed;
    private final Long2LongMap walkedPoses = new Long2LongOpenHashMap();
    private final MutableLong nextWalkTime = new MutableLong(0L);

    public SepalsWalkHomeTask(float speed) {
        this.speed = speed;
    }

    public static SepalsWalkHomeTask create(float speed) {
        return new SepalsWalkHomeTask(speed);
    }

    @Override
    public boolean complete(class_3218 world, class_1314 entity, long time) {
        if (world.method_8510() - this.nextWalkTime.getValue() < 20L) {
            return false;
        }
        class_4153 pointOfInterestStorage = world.method_19494();
        Optional<class_2338> optional = SepalsPointOfInterestStorage.getNearestPosition(pointOfInterestStorage, poiType -> poiType.method_40225(class_7477.field_39291), entity.method_24515(), 48, class_4153.class_4155.field_18489);
        if (optional.isPresent() && optional.get().method_10262((class_2382)entity.method_24515()) > 4.0) {
            MutableInt limiter = new MutableInt(0);
            this.nextWalkTime.setValue(world.method_8510() + (long)world.method_8409().method_43048(20));
            Predicate<class_2338> predicate = pos -> {
                long l = pos.method_10063();
                if (this.walkedPoses.containsKey(l)) {
                    return false;
                }
                if (limiter.incrementAndGet() >= 5) {
                    return false;
                }
                this.walkedPoses.put(l, this.nextWalkTime.getValue() + 40L);
                return true;
            };
            Pair<class_6880<class_4158>, class_2338>[] set = SepalsPointOfInterestStorage.getTypesAndPositions(pointOfInterestStorage, poiType -> poiType.method_40225(class_7477.field_39291), predicate, entity.method_24515(), 48, class_4153.class_4155.field_18489).safeArray();
            class_11 path = SepalsFindPointOfInterestTask.findPathToPoi((class_1308)entity, set);
            if (path == null || !path.method_21655()) {
                if (limiter.getValue() < 5) {
                    this.walkedPoses.long2LongEntrySet().removeIf(entry -> entry.getLongValue() < this.nextWalkTime.getValue());
                }
            } else {
                class_2338 blockPos = path.method_48();
                Optional optional2 = pointOfInterestStorage.method_19132(blockPos);
                if (optional2.isPresent()) {
                    this.remember(class_4140.field_18445, new class_4142(blockPos, this.speed, 1));
                    world.method_74535().method_74611(blockPos);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String information() {
        return "WalkHomeTask(nextWalk(waiting=" + (this.nextWalkTime.getValue() - this.currentTime()) + "), walked" + Arrays.toString(this.walkedPoses.values().longStream().toArray()) + ")";
    }
}

