/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.world;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.item.BoxedEntitiesCache;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1937.class})
public abstract class WorldMixin
implements BoxedEntitiesCache {
    @Unique
    private static final Supplier<Map<Long, List<class_1297>>> mapSupplier = () -> {
        if (Sepals.isAsyncLoaded) {
            return Collections.synchronizedMap(new Long2ObjectOpenHashMap());
        }
        return new Long2ObjectOpenHashMap();
    };
    @Unique
    private Map<Long, List<class_1297>> entities = Manipulate.supply(mapSupplier::get);
    @Unique
    private Map<Long, List<class_1297>> getByTypeEntities = Manipulate.supply(mapSupplier::get);

    @Unique
    public List<class_1297> cachedGetByType(long hashCode) {
        if (this.getByTypeEntities == null) {
            this.getByTypeEntities = mapSupplier.get();
        }
        return this.getByTypeEntities.get(hashCode);
    }

    @Unique
    public void cacheGetByType(long hashCode, List<class_1297> entities) {
        if (this.getByTypeEntities == null) {
            this.getByTypeEntities = mapSupplier.get();
        }
        this.getByTypeEntities.put(hashCode, entities);
    }

    @Override
    @Unique
    public void sepals$cache(class_238 box, List<class_1297> entities) {
        if (this.entities == null) {
            this.entities = mapSupplier.get();
        }
        this.entities.put(WorldMixin.boxHashCode(box), entities);
    }

    @Override
    @Unique
    public List<class_1297> sepals$cached(class_238 box) {
        if (this.entities == null) {
            this.entities = mapSupplier.get();
        }
        return this.entities.get(WorldMixin.boxHashCode(box));
    }

    @Override
    @Unique
    public void sepals$clearCache() {
        if (this.entities != null) {
            this.entities.clear();
        }
        if (this.getByTypeEntities != null) {
            this.getByTypeEntities.clear();
        }
    }

    @Inject(method={"getOtherEntities"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOtherEntities(class_1297 except, class_238 box, Predicate<? super class_1297> predicate, CallbackInfoReturnable<List<class_1297>> cir) {
        List<class_1297> result;
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming() && (result = this.cached(box)) != null) {
            cir.setReturnValue(result);
        }
    }

    @Inject(method={"getOtherEntities"}, at={@At(value="RETURN")})
    public void cacheOtherEntities(class_1297 except, class_238 box, Predicate<? super class_1297> predicate, CallbackInfoReturnable<List<class_1297>> cir) {
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
            this.cache(box, (List)cir.getReturnValue());
        }
    }

    @Inject(method={"getEntitiesByType"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends class_1297> void getEntitiesByType(class_5575<T, ? extends T> filter, class_238 box, Predicate<? super T> predicate, CallbackInfoReturnable<List<T>> cir) {
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
            long cacheKey = WorldMixin.boxHashCode(box);
            List<class_1297> cached = this.cachedGetByType(cacheKey);
            if (cached == null) {
                return;
            }
            Catheter<class_1297> catheter = Catheter.of(cached);
            List<class_1297> result = catheter.filter(predicate).varyTo(entity -> Manipulate.supply(() -> (class_1297)filter.method_31796(entity))).exists().list();
            if (!result.isEmpty()) {
                cir.setReturnValue(result);
            }
        }
    }

    @Inject(method={"getEntitiesByType"}, at={@At(value="RETURN")})
    public void cacheEntitiesByType(class_5575<class_1297, ? extends class_1297> filter, class_238 box, Predicate<? super class_1297> predicate, CallbackInfoReturnable<List<class_1297>> cir) {
        if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
            this.cacheGetByType(WorldMixin.boxHashCode(box), (List)cir.getReturnValue());
        }
    }

    @Unique
    private static long boxHashCode(class_238 box) {
        int minHash = Arrays.hashCode(new double[]{box.field_1323, box.field_1322, box.field_1321});
        int maxHash = Arrays.hashCode(new double[]{box.field_1320, box.field_1325, box.field_1324});
        return (long)minHash & 0xFFFFFFFFL | (long)maxHash << 32 & 0xFFFFFFFF00000000L;
    }

    @Unique
    private static long directBoxHashCode(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        long result = 1L;
        long bitsMinX = Double.doubleToLongBits(maxX);
        long bitsMinY = Double.doubleToLongBits(maxY);
        long bitsMinZ = Double.doubleToLongBits(maxZ);
        long bitsMaxX = Double.doubleToLongBits(minX);
        long bitsMaxY = Double.doubleToLongBits(minY);
        long bitsMaxZ = Double.doubleToLongBits(minZ);
        result = 31L * result + (bitsMinX ^ bitsMinX >>> 32);
        result = 31L * result + (bitsMinY ^ bitsMinY >>> 32);
        result = 31L * result + (bitsMinZ ^ bitsMinZ >>> 32);
        result = 31L * result + (bitsMaxX ^ bitsMaxX >>> 32);
        result = 31L * result + (bitsMaxY ^ bitsMaxY >>> 32);
        result = 31L * result + (bitsMaxZ ^ bitsMaxZ >>> 32);
        return result;
    }
}

