/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sinuatum.util.digger;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigger {
    private static final int BUF_SIZE = 16384;

    public static String digest(String message, DigestAlgorithm sha) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(sha.instanceName());
        digest.update(message.getBytes(StandardCharsets.UTF_8));
        StringBuilder result = new StringBuilder();
        MessageDigger.digest(digest, result);
        return result.toString();
    }

    public static String digestFile(File file, DigestAlgorithm sha) throws Exception {
        int length;
        if (!file.isFile()) {
            return "0";
        }
        RandomAccessFile accessFile = new RandomAccessFile(file, "r");
        MessageDigest digest = MessageDigest.getInstance(sha.instanceName());
        byte[] buffer = new byte[16384];
        long offset = accessFile.length();
        for (long read = 0L; read < offset; read += (long)length) {
            length = (int)(offset - read < 16384L ? offset - read : 16384L);
            accessFile.read(buffer, 0, length);
            digest.update(buffer, 0, length);
        }
        accessFile.close();
        StringBuilder result = new StringBuilder();
        MessageDigger.digest(digest, result);
        return result.toString();
    }

    private static void digest(MessageDigest digest, StringBuilder result) {
        for (byte b : digest.digest()) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                result.append(0);
            }
            result.append(hex);
        }
    }

    public static interface DigestAlgorithm {
        public String instanceName();
    }

    public static interface MD
    extends DigestAlgorithm {
    }

    public static interface Sha
    extends DigestAlgorithm {
    }

    public static enum MD5 implements MD
    {
        MD_5("MD5");

        private final String instance;

        private MD5(String instance) {
            this.instance = instance;
        }

        @Override
        public String instanceName() {
            return this.instance;
        }
    }

    public static enum MD4 implements MD
    {
        MD_4("MD4");

        private final String instance;

        private MD4(String instance) {
            this.instance = instance;
        }

        @Override
        public String instanceName() {
            return this.instance;
        }
    }

    public static enum Sha3 implements Sha
    {
        SHA_224("SHA3-224"),
        SHA_256("SHA3-256"),
        SHA_512("SHA3-512");

        private final String instance;

        private Sha3(String instance) {
            this.instance = instance;
        }

        @Override
        public String instanceName() {
            return this.instance;
        }
    }

    public static enum Sha1 implements Sha
    {
        SHA("SHA-1");

        private final String instance;

        private Sha1(String instance) {
            this.instance = instance;
        }

        @Override
        public String instanceName() {
            return this.instance;
        }
    }
}

