/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_combination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_combination.TrimKey;
import net.minecraft.class_5455;
import net.minecraft.class_8053;
import org.jetbrains.annotations.Nullable;

public record TrimCombination(List<String> allowedArmorMaterials, TrimKey helmetTrim, TrimKey chestplateTrim, TrimKey leggingsTrim, TrimKey bootsTrim) {
    private static final Map<TrimKey, class_8053> cachedTrims = new HashMap<TrimKey, class_8053>();

    public List<TrimKey> trims() {
        return new ArrayList<TrimKey>(List.of(this.helmetTrim, this.chestplateTrim, this.leggingsTrim, this.bootsTrim));
    }

    @Nullable
    public static TrimCombination getRandomTrimCombination(String requiredMaterial) {
        List<TrimCombination> trimCombinations = Config.CONFIG_MANAGER.instance().trimMobs.trimCombinations;
        if (!trimCombinations.isEmpty()) {
            Collections.shuffle(trimCombinations);
            for (TrimCombination trimCombination : trimCombinations) {
                if (!trimCombination.allowedArmorMaterials().contains(requiredMaterial)) continue;
                return trimCombination;
            }
        }
        return null;
    }

    @Nullable
    public static class_8053 getOrCreateCachedTrim(String material, String pattern, class_5455 registryAccess) {
        class_8053 trim = cachedTrims.get(new TrimKey(material, pattern));
        if (trim == null) {
            trim = new TrimKey(material, pattern).getTrim(registryAccess);
            if (trim == null) {
                return null;
            }
            cachedTrims.put(new TrimKey(material, pattern), trim);
        }
        return trim;
    }
}

