/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config.screen;

import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.TrimData;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen {
    public static final Formatters.Percentage percentageFormatter = new Formatters.Percentage();
    public static final Formatters.TrimSystem trimSystemFormatter = new Formatters.TrimSystem();

    private ConfigScreen() {
    }

    public static Screen getConfigScreen(Screen parent) {
        YetAnotherConfigLib.Builder configScreen = YetAnotherConfigLib.createBuilder().title((Component)Component.literal((String)"Naturally Trimmed")).save(Config.CONFIG_MANAGER::saveInstance).category(ConfigScreen.buildGeneralCategory()).category(ConfigScreen.buildUtilsCategory());
        return configScreen.build().generateScreen(parent);
    }

    private static ConfigCategory buildGeneralCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.general")).tooltip(new Component[]{Component.translatable((String)"naturally_trimmed.config.general.tooltip")}).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimMobs")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimMobs.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimMobs, () -> Config.CONFIG_MANAGER.instance().enableTrimMobs, enableTrimMobs -> {
            Config.CONFIG_MANAGER.instance().enableTrimMobs = enableTrimMobs;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimLootTables")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimLootTables.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimLootTables, () -> Config.CONFIG_MANAGER.instance().enableTrimLootTables, enableTrimLootTables -> {
            Config.CONFIG_MANAGER.instance().enableTrimLootTables = enableTrimLootTables;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimTrades")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimTrades.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimTrades, () -> Config.CONFIG_MANAGER.instance().enableTrimTrades, enableTrimTrades -> {
            Config.CONFIG_MANAGER.instance().enableTrimTrades = enableTrimTrades;
        }).controller(BooleanControllerBuilder::create).build()).build()).group(ConfigScreen.buildTrimMobsGroup()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimLootTables")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimLootTables.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimLootTables.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimLootTables.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimLootTables.trimChance, () -> Config.CONFIG_MANAGER.instance().trimLootTables.trimChance, trimChance -> {
            Config.CONFIG_MANAGER.instance().trimLootTables.trimChance = trimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).build()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimTrades")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimTrades.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimTrades.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimTrades.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimTrades.trimChance, () -> Config.CONFIG_MANAGER.instance().trimTrades.trimChance, trimChance -> {
            Config.CONFIG_MANAGER.instance().trimTrades.trimChance = trimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimTrades.minLevel")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimTrades.minLevel.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimTrades.minLevel, () -> Config.CONFIG_MANAGER.instance().trimTrades.minLevel, minLevel -> {
            Config.CONFIG_MANAGER.instance().trimTrades.minLevel = minLevel;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)1, (Number)5)).step((Number)1)).build()).build()).build();
    }

    private static OptionGroup buildTrimMobsGroup() {
        return OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.tooltip")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.trimSystem")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.trimSystem.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.trimSystem, () -> Config.CONFIG_MANAGER.instance().trimMobs.trimSystem, enabledSystem -> {
            Config.CONFIG_MANAGER.instance().trimMobs.trimSystem = enabledSystem;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(Config.TrimMobsSubConfig.TrimSystem.class).formatValue((ValueFormatter)trimSystemFormatter)).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.noTrimsChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.noTrimsChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.noTrimsChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance, noTrimsChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance = noTrimsChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.trimChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.trimChance, trimsChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.trimChance = trimsChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).build();
    }

    private static ConfigCategory buildUtilsCategory() {
        boolean isInWorld = Minecraft.getInstance().level != null;
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils")).tooltip(new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.tooltip")}).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils.reloadConfig")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.reloadConfig.description")})).text((Component)Component.translatable((String)"naturally_trimmed.config.utils.run")).action((screen, option) -> {
            Config.CONFIG_MANAGER.loadInstance();
            screen.onClose();
        }).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils.validatePredefinedTrims")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.validatePredefinedTrims.description")})).text((Component)(isInWorld ? Component.translatable((String)"naturally_trimmed.config.utils.run") : Component.translatable((String)"naturally_trimmed.config.utils.run").withStyle(ChatFormatting.STRIKETHROUGH))).action((screen, option) -> ConfigScreen.validatePredefinedTrims()).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validatePredefinedTrims() {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || player == null) {
            return;
        }
        RegistryAccess registryAccess = level.registryAccess();
        player.displayClientMessage((Component)Component.literal((String)"\nValidating predefined trims...\n"), false);
        int total = Config.CONFIG_MANAGER.instance().trimMobs.predefinedTrims.size();
        int valid = 0;
        int index = 0;
        for (TrimData trimData : Config.CONFIG_MANAGER.instance().trimMobs.predefinedTrims) {
            try {
                trimData.getTrim(registryAccess);
                ++valid;
            }
            catch (NoSuchElementException | ResourceLocationException ignored) {
                player.displayClientMessage((Component)Component.literal((String)("Found invalid trim: \"" + String.valueOf(trimData) + "\" with index " + index)), false);
            }
            finally {
                ++index;
            }
        }
        player.displayClientMessage((Component)Component.literal((String)("\n" + valid + " out of " + total + " trims are valid.")), false);
        player.displayClientMessage((Component)Component.literal((String)"Done validating predefined trims"), false);
    }

    public static class Formatters {
        private Formatters() {
        }

        public static class TrimSystem
        implements ValueFormatter<Config.TrimMobsSubConfig.TrimSystem> {
            public Component format(Config.TrimMobsSubConfig.TrimSystem selectedSystem) {
                return switch (selectedSystem) {
                    default -> throw new IncompatibleClassChangeError();
                    case Config.TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS -> Component.translatable((String)"naturally_trimmed.config.trimMobs.trimSystem.randomTrims");
                    case Config.TrimMobsSubConfig.TrimSystem.PREDEFINED_TRIMS -> Component.translatable((String)"naturally_trimmed.config.trimMobs.trimSystem.predefinedTrims");
                };
            }
        }

        public static class Percentage
        implements ValueFormatter<Integer> {
            public Component format(Integer value) {
                return Component.literal((String)(value.toString() + "%"));
            }
        }
    }

    static class BackupScreen
    extends OptionsSubScreen {
        public BackupScreen(Screen parent) {
            super(parent, Minecraft.getInstance().options, (Component)Component.literal((String)"Naturally Trimmed"));
        }

        public void init() {
            MultiLineTextWidget messageWidget = new MultiLineTextWidget(this.width / 2 - 110, this.height / 2 - 40, (Component)Component.translatable((String)"naturally_trimmed.config.backup_screen.installYACL"), Objects.requireNonNull(this.minecraft).font);
            messageWidget.setMaxWidth(240);
            messageWidget.setCentered(true);
            this.addRenderableWidget((GuiEventListener)messageWidget);
            Button openLinkButton = Button.builder((Component)Component.translatable((String)"naturally_trimmed.config.backup_screen.viewOnModrinth"), button -> this.minecraft.setScreen((Screen)new ConfirmLinkScreen(open -> {
                if (open) {
                    Util.getPlatform().openUri("https://modrinth.com/mod/yacl");
                }
                this.minecraft.setScreen(this.lastScreen);
            }, "https://modrinth.com/mod/yacl", true))).pos(this.width / 2 - 120, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)openLinkButton);
            Button exitButton = Button.builder((Component)CommonComponents.GUI_OK, button -> this.onClose()).pos(this.width / 2 + 5, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)exitButton);
        }

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            super.render(graphics, mouseX, mouseY, delta);
            graphics.drawCenteredString(this.font, this.title, this.width / 2, 5, 0xFFFFFF);
        }
    }
}

