/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimData;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class TrimApplier {
    private TrimApplier() {
    }

    public static void applyTrim(ItemStack itemStack, ArmorTrim armorTrim, RegistryAccess registryAccess) {
        ArmorTrim.setTrim((RegistryAccess)registryAccess, (ItemStack)itemStack, (ArmorTrim)armorTrim);
    }

    public static ArmorTrim getRandomTrim(RegistryAccess registryAccess, RandomSource random) {
        Holder.Reference trimPattern;
        Holder.Reference trimMaterial;
        Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
        List<Holder.Reference<TrimPattern>> trimPatterns = TrimApplier.getPatterns((Registry<TrimPattern>)((Registry)registries.getSecond()));
        trimPatterns.removeIf(pattern -> pattern.key().location().getNamespace().equals("tooltrims"));
        do {
            trimPattern = (Holder.Reference)Util.getRandom(trimPatterns, (RandomSource)random);
        } while (!(trimMaterial = (Holder.Reference)((Registry)registries.getFirst()).getRandom(random).orElseThrow()).key().location().getNamespace().equals("minecraft") && !trimPattern.key().location().getNamespace().equals("minecraft"));
        return new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
    }

    public static void trimEquipment(LivingEntity entity) {
        ArmorTrim trim;
        if (!Config.CONFIG_MANAGER.instance().enableTrimMobs) {
            return;
        }
        if (Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance >= entity.getRandom().nextInt(100)) {
            return;
        }
        List<ItemStack> armor = StreamSupport.stream(entity.getArmorSlots().spliterator(), false).filter(armorPiece -> !armorPiece.isEmpty() && armorPiece.is(ItemTags.TRIMMABLE_ARMOR)).toList();
        RandomSource random = entity.getRandom();
        RegistryAccess registryAccess = entity.level().registryAccess();
        Config.TrimMobsSubConfig.TrimSystem enabledSystem = Config.CONFIG_MANAGER.instance().trimMobs.trimSystem;
        ArmorTrim armorTrim = trim = enabledSystem == Config.TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS ? TrimApplier.getRandomTrim(registryAccess, random) : TrimApplier.getPredefinedTrim(registryAccess);
        if (trim == null) {
            return;
        }
        for (ItemStack armorPiece2 : armor) {
            if (Config.CONFIG_MANAGER.instance().trimMobs.trimChance < random.nextInt(100)) continue;
            TrimApplier.applyTrim(armorPiece2, trim, registryAccess);
        }
        if ((NaturallyTrimmed.isModLoaded("tooltrims") || NaturallyTrimmed.isModLoaded("trimmable_tools")) && Config.CONFIG_MANAGER.instance().trimMobs.trimChance >= random.nextInt(100)) {
            ToolTrimsCompat.applyTrimToTool(entity.getMainHandItem(), (Holder<TrimMaterial>)trim.material(), registryAccess, random);
        }
    }

    protected static Pair<Registry<TrimMaterial>, Registry<TrimPattern>> getTrimRegistries(RegistryAccess registryAccess) {
        Registry materialRegistry = registryAccess.registryOrThrow(Registries.TRIM_MATERIAL);
        Registry patternRegistry = registryAccess.registryOrThrow(Registries.TRIM_PATTERN);
        return new Pair((Object)materialRegistry, (Object)patternRegistry);
    }

    protected static List<Holder.Reference<TrimPattern>> getPatterns(Registry<TrimPattern> patternRegistry) {
        return new ArrayList<Holder.Reference<TrimPattern>>(patternRegistry.holders().toList());
    }

    @Nullable
    private static ArmorTrim getPredefinedTrim(RegistryAccess registryAccess) {
        List<TrimData> predefinedTrims = Config.CONFIG_MANAGER.instance().trimMobs.predefinedTrims;
        Collections.shuffle(predefinedTrims);
        Iterator<TrimData> iterator = predefinedTrims.iterator();
        if (iterator.hasNext()) {
            TrimData predefinedTrim = iterator.next();
            try {
                return predefinedTrim.getTrim(registryAccess);
            }
            catch (NoSuchElementException | ResourceLocationException e) {
                return null;
            }
        }
        return null;
    }
}

