/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.majo24.naturally_trimmed.RegistryHelper;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimApplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class TrimLootTablesFunction
extends LootItemConditionalFunction {
    public static final Codec<TrimLootTablesFunction> CODEC = RecordCodecBuilder.create(instance -> TrimLootTablesFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TrimLootTablesFunction::new));

    protected TrimLootTablesFunction(List<LootItemCondition> predicates) {
        super(predicates);
    }

    @NotNull
    public LootItemFunctionType getType() {
        return (LootItemFunctionType)RegistryHelper.TRIM_LOOT_TABLES_FUNCTION.get();
    }

    @NotNull
    protected ItemStack run(ItemStack itemStack, @NotNull LootContext lootContext) {
        if (!Config.CONFIG_MANAGER.instance().enableTrimLootTables) {
            return itemStack;
        }
        if (!itemStack.is(ItemTags.TRIMMABLE_ARMOR) && !itemStack.is(ToolTrimsCompat.TRIMMABLE_TOOLS_TAG)) {
            return itemStack;
        }
        RandomSource random = lootContext.getRandom();
        RegistryAccess registryAccess = lootContext.getLevel().registryAccess();
        if (Config.CONFIG_MANAGER.instance().trimLootTables.trimChance < random.nextInt(100)) {
            return itemStack;
        }
        ArmorTrim trim = TrimApplier.getRandomTrim(registryAccess, random);
        if (trim == null) {
            return itemStack;
        }
        if (itemStack.is(ItemTags.TRIMMABLE_ARMOR)) {
            TrimApplier.applyTrim(itemStack, trim, registryAccess);
        } else {
            ToolTrimsCompat.applyTrimToTool(itemStack, (Holder<TrimMaterial>)trim.material(), registryAccess, random);
        }
        return itemStack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return TrimLootTablesFunction.simpleBuilder(TrimLootTablesFunction::new);
    }
}

