/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.trim_application.TrimApplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public class ToolTrimsCompat {
    public static final String TRIMMABLE_TOOLS_ID = "trimmable_tools";
    public static final String TOOL_TRIMS_ID = "tooltrims";
    public static final TagKey<Item> TRIMMABLE_TOOL_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"tooltrims", (String)"trimmable_tools")));

    private ToolTrimsCompat() {
    }

    public static void toolTrimsCompat(ItemStack itemStack, RegistryAccess registryAccess, RandomSource random) {
        if (!itemStack.isEmpty() && (itemStack.is(TRIMMABLE_TOOL_TAG) || itemStack.is(ItemTags.TRIMMABLE_ARMOR))) {
            Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
            Registry materialRegistry = (Registry)registries.getFirst();
            Registry patternRegistry = (Registry)registries.getSecond();
            ArmorTrim trim = new ArmorTrim((Holder)materialRegistry.getRandom(random).orElseThrow(), ToolTrimsCompat.getRandomToolPattern((Registry<TrimPattern>)patternRegistry, random));
            TrimApplier.applyTrim(itemStack, trim, registryAccess);
        }
    }

    private static Holder.Reference<TrimPattern> getRandomToolPattern(Registry<TrimPattern> patternRegistry, RandomSource random) {
        List<Holder.Reference<TrimPattern>> patterns = TrimApplier.getPatterns(patternRegistry);
        if (NaturallyTrimmed.isModLoaded(TRIMMABLE_TOOLS_ID)) {
            patterns.removeIf(pattern -> !pattern.key().location().getNamespace().equals("minecraft"));
        } else if (NaturallyTrimmed.isModLoaded(TOOL_TRIMS_ID)) {
            patterns.removeIf(pattern -> !pattern.key().location().getNamespace().equals(TOOL_TRIMS_ID));
        }
        return (Holder.Reference)Util.getRandom(patterns, (RandomSource)random);
    }
}

