/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.majo24.naturally_trimmed.RegistryHelper;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimApplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class TrimLootTablesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<TrimLootTablesFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> TrimLootTablesFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TrimLootTablesFunction::new));

    protected TrimLootTablesFunction(List<LootItemCondition> predicates) {
        super(predicates);
    }

    @NotNull
    public LootItemFunctionType getType() {
        return (LootItemFunctionType)RegistryHelper.TRIM_LOOT_TABLES_FUNCTION.get();
    }

    @NotNull
    protected ItemStack run(ItemStack itemStack, @NotNull LootContext lootContext) {
        if (!Config.CONFIG_MANAGER.instance().enableTrimLootTables) {
            return itemStack;
        }
        if (!itemStack.is(ItemTags.TRIMMABLE_ARMOR) && !itemStack.is(ToolTrimsCompat.TRIMMABLE_TOOL_TAG)) {
            return itemStack;
        }
        RandomSource random = lootContext.getRandom();
        RegistryAccess registryAccess = lootContext.getLevel().registryAccess();
        if (Config.CONFIG_MANAGER.instance().trimLootTables.trimChance < random.nextInt(100)) {
            return itemStack;
        }
        if (itemStack.is(ItemTags.TRIMMABLE_ARMOR)) {
            TrimApplier.applyRandomTrimToItem(itemStack, registryAccess, random);
        } else {
            ToolTrimsCompat.toolTrimsCompat(itemStack, registryAccess, random);
        }
        return itemStack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return TrimLootTablesFunction.simpleBuilder(TrimLootTablesFunction::new);
    }
}

