/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config;

import java.util.List;
import java.util.regex.Pattern;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.TrimMobsSubConfig;
import net.majo24.naturally_trimmed.config.backend.ConfigManager;
import net.majo24.naturally_trimmed.config.backend.annotations.Entry;
import net.majo24.naturally_trimmed.config.backend.annotations.SubConfig;

public class Config {
    public static final ConfigManager<Config> CONFIG_MANAGER = new ConfigManager<Config>(Config.class, NaturallyTrimmed.getConfigPath());
    @Entry(name="enable_trim_mobs", comment="Enables the equipment from mobs to be trimmed")
    public boolean enableTrimMobs = true;
    @Entry(name="enable_trim_loot_tables", comment="Enables the equipment generated by loot tables to be trimmed")
    public boolean enableTrimLootTables = true;
    @Entry(name="enable_trim_trades", comment="Enables the equipment from villager trades to be trimmed")
    public boolean enableTrimTrades = true;
    @Entry(name="blacklist", comment="Blacklist for trim patterns.\n\nThis uses regex. This means, if you want to check for a specific pattern, you need to use \"^[pattern$]\" instead of just \"[pattern]\".\nBy default, all patterns from the Trimmable Tools mod are blacklisted, since they only work for tools and not armor\n\nTo ease the configuration of the blacklist, theres a utils tab inside the config screen, which contains a button to validate the blacklist.")
    public List<Pattern> blacklist = List.of(Pattern.compile("^tooltrims:.*"));
    @SubConfig(name="trim_mobs", comment="Settings for trimming a mob's equipment")
    public TrimMobsSubConfig trimMobs = new TrimMobsSubConfig();
    @SubConfig(name="trim_loot_tables", comment="Settings for trimming equipment generated by loot tables")
    public TrimLootTablesSubConfig trimLootTables = new TrimLootTablesSubConfig();
    @SubConfig(name="trim_trades", comment="Settings for trimming equipment from villager trades")
    public TrimTradesSubConfig trimTrades = new TrimTradesSubConfig();

    public static class TrimLootTablesSubConfig {
        @Entry(name="trim_chance", comment="Chance of an item generated by a loot table of having a trim applied")
        public int trimChance = 50;
    }

    public static class TrimTradesSubConfig {
        @Entry(name="trim_chance", comment="Chance of a villager trade of having a trim applied")
        public int trimChance = 50;
        @Entry(name="min_level", comment="The minimum villager trading level an item needs to be in, to have a chance of being trimmed")
        public int minLevel = 3;
    }
}

