/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config.screen;

import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.Objects;
import java.util.regex.Pattern;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.config.TrimMobsSubConfig;
import net.majo24.naturally_trimmed.config.screen.SettingsValidation;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen {
    public static final Formatters.Percentage percentageFormatter = new Formatters.Percentage();
    public static final Formatters.TrimSystem trimSystemFormatter = new Formatters.TrimSystem();

    private ConfigScreen() {
    }

    public static Screen getConfigScreen(Screen parent) {
        YetAnotherConfigLib.Builder configScreen = YetAnotherConfigLib.createBuilder().title((Component)Component.m_237113_((String)"Naturally Trimmed")).save(Config.CONFIG_MANAGER::saveInstance).category(ConfigScreen.buildGeneralCategory()).category(ConfigScreen.buildUtilsCategory());
        return configScreen.build().generateScreen(parent);
    }

    private static ConfigCategory buildGeneralCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.general")).tooltip(new Component[]{Component.m_237115_((String)"naturally_trimmed.config.general.tooltip")}).group(OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.enable_features")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.enable_features.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.enable_features.enableTrimMobs")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.enable_features.enableTrimMobs.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimMobs, () -> Config.CONFIG_MANAGER.instance().enableTrimMobs, enableTrimMobs -> {
            Config.CONFIG_MANAGER.instance().enableTrimMobs = enableTrimMobs;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.enable_features.enableTrimLootTables")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.enable_features.enableTrimLootTables.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimLootTables, () -> Config.CONFIG_MANAGER.instance().enableTrimLootTables, enableTrimLootTables -> {
            Config.CONFIG_MANAGER.instance().enableTrimLootTables = enableTrimLootTables;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.enable_features.enableTrimTrades")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.enable_features.enableTrimTrades.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimTrades, () -> Config.CONFIG_MANAGER.instance().enableTrimTrades, enableTrimTrades -> {
            Config.CONFIG_MANAGER.instance().enableTrimTrades = enableTrimTrades;
        }).controller(BooleanControllerBuilder::create).build()).build()).group(ConfigScreen.buildTrimMobsGroup()).group(OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimLootTables")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimLootTables.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimLootTables.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimLootTables.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimLootTables.trimChance, () -> Config.CONFIG_MANAGER.instance().trimLootTables.trimChance, trimChance -> {
            Config.CONFIG_MANAGER.instance().trimLootTables.trimChance = trimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).build()).group(OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimTrades")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimTrades.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimTrades.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimTrades.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimTrades.trimChance, () -> Config.CONFIG_MANAGER.instance().trimTrades.trimChance, trimChance -> {
            Config.CONFIG_MANAGER.instance().trimTrades.trimChance = trimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimTrades.minLevel")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimTrades.minLevel.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimTrades.minLevel, () -> Config.CONFIG_MANAGER.instance().trimTrades.minLevel, minLevel -> {
            Config.CONFIG_MANAGER.instance().trimTrades.minLevel = minLevel;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)1, (Number)5)).step((Number)1)).build()).build()).group((OptionGroup)ListOption.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.blacklist")).collapsed(true).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.blacklist.description")})).binding(Config.CONFIG_MANAGER.defaults().blacklist.stream().map(Pattern::pattern).toList(), () -> Config.CONFIG_MANAGER.instance().blacklist.stream().map(Pattern::pattern).toList(), blacklist -> {
            Config.CONFIG_MANAGER.instance().blacklist = blacklist.stream().map(Pattern::compile).toList();
        }).controller(StringControllerBuilder::create).initial((Object)"").build()).build();
    }

    private static OptionGroup buildTrimMobsGroup() {
        return OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimMobs")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimMobs.tooltip")})).collapsed(true).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimMobs.trimSystem")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimMobs.trimSystem.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.trimSystem, () -> Config.CONFIG_MANAGER.instance().trimMobs.trimSystem, enabledSystem -> {
            Config.CONFIG_MANAGER.instance().trimMobs.trimSystem = enabledSystem;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(TrimMobsSubConfig.TrimSystem.class).formatValue((ValueFormatter)trimSystemFormatter)).build()).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimMobs.noTrimsChance")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimMobs.noTrimsChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.noTrimsChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance, noTrimsChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance = noTrimsChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option((Option)LabelOption.create((Component)Component.m_237115_((String)"naturally_trimmed.config.trimMobs.randomTrims.description"))).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimMobs.randomTrims.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimMobs.randomTrims.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.randomTrims.trimChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance, trimsChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance = trimsChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option(Option.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.trimMobs.randomTrims.similarTrimChance")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.trimMobs.randomTrims.similarTrimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.randomTrims.similarTrimChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance, similarTrimChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance = similarTrimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).build();
    }

    private static ConfigCategory buildUtilsCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.utils")).tooltip(new Component[]{Component.m_237115_((String)"naturally_trimmed.config.utils.tooltip")}).option((Option)ButtonOption.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.utils.reloadConfig")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.utils.reloadConfig.description")})).action((screen, option) -> {
            Config.CONFIG_MANAGER.loadInstance();
            screen.m_7379_();
        }).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.utils.validateCustomTrimCombinations")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.utils.validateCustomTrimCombinations.description")})).action((screen, option) -> SettingsValidation.validateTrimCombinations()).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.m_237115_((String)"naturally_trimmed.config.utils.validateBlacklist")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"naturally_trimmed.config.utils.validateBlacklist.description")})).action((screen, option) -> SettingsValidation.validateBlacklist()).build()).build();
    }

    public static class Formatters {
        private Formatters() {
        }

        public static class TrimSystem
        implements ValueFormatter<TrimMobsSubConfig.TrimSystem> {
            public Component format(TrimMobsSubConfig.TrimSystem selectedSystem) {
                return switch (selectedSystem) {
                    default -> throw new IncompatibleClassChangeError();
                    case TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS -> Component.m_237113_((String)"Random Trims");
                    case TrimMobsSubConfig.TrimSystem.CUSTOM_TRIM_COMBINATIONS -> Component.m_237113_((String)"Custom Trim Combinations");
                };
            }
        }

        public static class Percentage
        implements ValueFormatter<Integer> {
            public Component format(Integer value) {
                return Component.m_237113_((String)(value.toString() + "%"));
            }
        }
    }

    static class BackupScreen
    extends OptionsSubScreen {
        public BackupScreen(Screen parent) {
            super(parent, Minecraft.m_91087_().f_91066_, (Component)Component.m_237113_((String)"Naturally Trimmed"));
        }

        public void m_7856_() {
            MultiLineTextWidget messageWidget = new MultiLineTextWidget(this.f_96543_ / 2 - 110, this.f_96544_ / 2 - 40, (Component)Component.m_237115_((String)"naturally_trimmed.config.backup_screen.installYACL"), Objects.requireNonNull(this.f_96541_).f_91062_);
            messageWidget.m_269098_(240);
            messageWidget.m_269484_(true);
            this.m_142416_((GuiEventListener)messageWidget);
            Button openLinkButton = Button.m_253074_((Component)Component.m_237115_((String)"naturally_trimmed.config.backup_screen.viewOnModrinth"), button -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(open -> {
                if (open) {
                    Util.m_137581_().m_137646_("https://modrinth.com/mod/yacl");
                }
                this.f_96541_.m_91152_(this.f_96281_);
            }, "https://modrinth.com/mod/yacl", true))).m_252794_(this.f_96543_ / 2 - 120, this.f_96544_ / 2).m_253046_(115, 20).m_253136_();
            this.m_142416_((GuiEventListener)openLinkButton);
            Button exitButton = Button.m_253074_((Component)CommonComponents.f_286989_, button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ / 2).m_253046_(115, 20).m_253136_();
            this.m_142416_((GuiEventListener)exitButton);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.m_280039_(graphics);
            super.m_88315_(graphics, mouseX, mouseY, delta);
            graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 5, 0xFFFFFF);
        }
    }
}

