/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.config.TrimMobsSubConfig;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_combination.TrimCombination;
import net.majo24.naturally_trimmed.trim_combination.TrimKey;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class TrimApplier {
    private TrimApplier() {
    }

    public static void trimEquipment(LivingEntity entity) {
        if (!Config.CONFIG_MANAGER.instance().enableTrimMobs) {
            return;
        }
        List<ItemStack> armor = StreamSupport.stream(entity.m_6168_().spliterator(), false).filter(armorPiece -> !armorPiece.m_41619_() && armorPiece.m_204117_(ItemTags.f_265942_)).toList();
        RandomSource random = entity.m_217043_();
        if (Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance < random.m_188503_(100)) {
            if (!armor.isEmpty()) {
                TrimApplier.applyTrims(entity.m_9236_().m_9598_(), random, armor);
            }
            if ((NaturallyTrimmed.isModLoaded("tooltrims") || NaturallyTrimmed.isModLoaded("trimmable_tools")) && Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance >= random.m_188503_(100)) {
                ToolTrimsCompat.toolTrimsCompat(entity.m_21205_(), entity.m_9236_().m_9598_(), entity.m_217043_());
            }
        }
    }

    public static void applyTrims(RegistryAccess registryAccess, RandomSource random, List<ItemStack> armor) {
        TrimMobsSubConfig.TrimSystem enabledSystem = Config.CONFIG_MANAGER.instance().trimMobs.trimSystem;
        if (enabledSystem == TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS) {
            TrimApplier.runRandomTrimsSystem(registryAccess, random, armor);
        } else {
            TrimApplier.runCustomTrimCombinationsSystem(armor, registryAccess);
        }
    }

    public static void runRandomTrimsSystem(RegistryAccess registryAccess, RandomSource random, Iterable<ItemStack> armor) {
        Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
        Registry materialRegistry = (Registry)registries.getFirst();
        Registry patternRegistry = (Registry)registries.getSecond();
        Pair<Holder.Reference<TrimMaterial>, Holder.Reference<TrimPattern>> lastTrim = null;
        for (ItemStack armorPiece : armor) {
            if (Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance < random.m_188503_(100)) continue;
            lastTrim = TrimApplier.applyRandomTrim(registryAccess, (Registry<TrimMaterial>)materialRegistry, (Registry<TrimPattern>)patternRegistry, random, armorPiece, lastTrim);
        }
    }

    public static Pair<Registry<TrimMaterial>, Registry<TrimPattern>> getTrimRegistries(RegistryAccess registryAccess) {
        ResourceKey materialKey = Registries.f_266076_;
        ResourceKey patternKey = Registries.f_266063_;
        Registry materialRegistry = registryAccess.m_175515_(materialKey);
        Registry patternRegistry = registryAccess.m_175515_(patternKey);
        return new Pair((Object)materialRegistry, (Object)patternRegistry);
    }

    public static void runCustomTrimCombinationsSystem(List<ItemStack> armor, RegistryAccess registryAccess) {
        String requiredMaterial = TrimApplier.getArmorMaterial(armor.getFirst());
        if (requiredMaterial == null) {
            return;
        }
        TrimCombination trimCombination = TrimCombination.getRandomTrimCombination(requiredMaterial);
        if (trimCombination == null) {
            return;
        }
        Iterator<ItemStack> armorIterator = armor.iterator();
        for (TrimKey trim : trimCombination.trims().reversed()) {
            ItemStack armorPiece = armorIterator.next();
            ArmorTrim armorTrim = TrimCombination.getOrCreateCachedTrim(trim.material(), trim.pattern(), registryAccess);
            if (armorTrim == null) continue;
            TrimApplier.applyTrim(armorPiece, armorTrim, registryAccess);
        }
    }

    @Nullable
    private static String getArmorMaterial(ItemStack armorPiece) {
        for (String material : List.of("netherite", "diamond", "gold", "iron", "chainmail", "copper", "leather")) {
            if (!armorPiece.toString().contains(material)) continue;
            return material;
        }
        NaturallyTrimmed.LOGGER.error("Could not find armor material for {}", (Object)armorPiece);
        return null;
    }

    public static void applyTrim(ItemStack itemStack, ArmorTrim armorTrim, RegistryAccess registryAccess) {
        ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)itemStack, (ArmorTrim)armorTrim);
    }

    @Nullable
    public static Pair<Holder.Reference<TrimMaterial>, Holder.Reference<TrimPattern>> applyRandomTrim(RegistryAccess registryAccess, Registry<TrimMaterial> materialRegistry, Registry<TrimPattern> patternRegistry, RandomSource random, ItemStack itemStack, @Nullable Pair<Holder.Reference<TrimMaterial>, Holder.Reference<TrimPattern>> referenceTrim) {
        List<Holder.Reference<TrimPattern>> trimPatterns = TrimApplier.getAndFilterPatterns(patternRegistry);
        if (trimPatterns.isEmpty()) {
            return null;
        }
        boolean newMaterial = true;
        Holder.Reference trimMaterial = null;
        boolean newPattern = true;
        Holder.Reference trimPattern = null;
        if (referenceTrim != null) {
            int similarTrimChance = Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance;
            if (similarTrimChance >= random.m_188503_(100)) {
                trimMaterial = (Holder.Reference)referenceTrim.getFirst();
                newMaterial = false;
            }
            if (similarTrimChance >= random.m_188503_(100)) {
                trimPattern = (Holder.Reference)referenceTrim.getSecond();
                newPattern = false;
            }
        }
        do {
            if (newPattern) {
                trimPattern = (Holder.Reference)Util.m_214621_(trimPatterns, (RandomSource)random);
            }
            if (!newMaterial) continue;
            trimMaterial = (Holder.Reference)materialRegistry.m_213642_(random).orElseThrow();
        } while (!trimMaterial.m_205785_().m_135782_().m_135827_().equals("minecraft") && !trimPattern.m_205785_().m_135782_().m_135827_().equals("minecraft"));
        ArmorTrim armorTrim = new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
        TrimApplier.applyTrim(itemStack, armorTrim, registryAccess);
        return new Pair((Object)trimMaterial, (Object)trimPattern);
    }

    private static List<Holder.Reference<TrimPattern>> getAndFilterPatterns(Registry<TrimPattern> patternRegistry) {
        List<Holder.Reference<TrimPattern>> trimPatterns = TrimApplier.getPatterns(patternRegistry);
        List<Pattern> patterns = Config.CONFIG_MANAGER.instance().blacklist;
        trimPatterns.removeIf(trimPattern -> {
            String resourceLocation = trimPattern.m_205785_().m_135782_().toString();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(resourceLocation).find()) continue;
                return true;
            }
            return false;
        });
        return trimPatterns;
    }

    public static List<Holder.Reference<TrimPattern>> getPatterns(Registry<TrimPattern> patternRegistry) {
        return new ArrayList<Holder.Reference<TrimPattern>>(patternRegistry.m_203611_().toList());
    }

    public static void applyRandomTrimToItem(ItemStack itemStack, RegistryAccess registryAccess, RandomSource random) {
        Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
        Registry materialRegistry = (Registry)registries.getFirst();
        Registry patternRegistry = (Registry)registries.getSecond();
        TrimApplier.applyRandomTrim(registryAccess, (Registry<TrimMaterial>)materialRegistry, (Registry<TrimPattern>)patternRegistry, random, itemStack, null);
    }
}

