/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_combination;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public record TrimKey(String material, String pattern) {
    private static final String TRIM_PATTERN_SUFFIX = "_armor_trim_smithing_template";

    @Nullable
    public ArmorTrim getTrim(RegistryAccess registryAccess) {
        Holder<TrimMaterial> trimMaterial = this.getMaterial(this.material, registryAccess);
        if (trimMaterial == null) {
            return null;
        }
        Holder<TrimPattern> trimPattern = this.getPattern(this.pattern, registryAccess);
        if (trimPattern == null && (trimPattern = this.getPattern(this.pattern + TRIM_PATTERN_SUFFIX, registryAccess)) == null) {
            return null;
        }
        return new ArmorTrim(trimMaterial, trimPattern);
    }

    @Nullable
    private Holder<TrimMaterial> getMaterial(String material, RegistryAccess registryAccess) {
        try {
            ItemStack materialItem = this.getItemFromId(material);
            return (Holder)TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)materialItem).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private Holder<TrimPattern> getPattern(String pattern, RegistryAccess registryAccess) {
        try {
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)pattern);
            return (Holder)registryAccess.m_255025_(Registries.f_266063_).m_214062_().filter(reference -> reference.m_205785_().m_135782_().equals((Object)resourceLocation)).findFirst().orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    private ItemStack getItemFromId(String id) {
        return ((Item)BuiltInRegistries.f_257033_.m_7745_(Objects.requireNonNull(ResourceLocation.m_135820_((String)id)))).m_7968_();
    }
}

