/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimData;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class TrimApplier {
    private TrimApplier() {
    }

    public static void applyTrim(ItemStack itemStack, ArmorTrim armorTrim, RegistryAccess registryAccess) {
        ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)itemStack, (ArmorTrim)armorTrim);
    }

    public static ArmorTrim getRandomTrim(RegistryAccess registryAccess, RandomSource random) {
        Holder.Reference trimPattern;
        Holder.Reference trimMaterial;
        Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
        List<Holder.Reference<TrimPattern>> trimPatterns = TrimApplier.getPatterns((Registry<TrimPattern>)((Registry)registries.getSecond()));
        trimPatterns.removeIf(pattern -> pattern.m_205785_().m_135782_().m_135827_().equals("tooltrims"));
        do {
            trimPattern = (Holder.Reference)Util.m_214621_(trimPatterns, (RandomSource)random);
        } while (!(trimMaterial = (Holder.Reference)((Registry)registries.getFirst()).m_213642_(random).orElseThrow()).m_205785_().m_135782_().m_135827_().equals("minecraft") && !trimPattern.m_205785_().m_135782_().m_135827_().equals("minecraft"));
        return new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
    }

    public static void trimEquipment(LivingEntity entity) {
        ArmorTrim trim;
        if (!Config.CONFIG_MANAGER.instance().enableTrimMobs) {
            return;
        }
        if (Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance >= entity.m_217043_().m_188503_(100)) {
            return;
        }
        List<ItemStack> armor = StreamSupport.stream(entity.m_6168_().spliterator(), false).filter(armorPiece -> !armorPiece.m_41619_() && armorPiece.m_204117_(ItemTags.f_265942_)).toList();
        RandomSource random = entity.m_217043_();
        RegistryAccess registryAccess = entity.m_9236_().m_9598_();
        Config.TrimMobsSubConfig.TrimSystem enabledSystem = Config.CONFIG_MANAGER.instance().trimMobs.trimSystem;
        ArmorTrim armorTrim = trim = enabledSystem == Config.TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS ? TrimApplier.getRandomTrim(registryAccess, random) : TrimApplier.getPredefinedTrim(registryAccess);
        if (trim == null) {
            return;
        }
        for (ItemStack armorPiece2 : armor) {
            if (Config.CONFIG_MANAGER.instance().trimMobs.trimChance < random.m_188503_(100)) continue;
            TrimApplier.applyTrim(armorPiece2, trim, registryAccess);
        }
        if ((NaturallyTrimmed.isModLoaded("tooltrims") || NaturallyTrimmed.isModLoaded("trimmable_tools")) && Config.CONFIG_MANAGER.instance().trimMobs.trimChance >= random.m_188503_(100)) {
            ToolTrimsCompat.applyTrimToTool(entity.m_21205_(), (Holder<TrimMaterial>)trim.m_266210_(), registryAccess, random);
        }
    }

    protected static Pair<Registry<TrimMaterial>, Registry<TrimPattern>> getTrimRegistries(RegistryAccess registryAccess) {
        Registry materialRegistry = registryAccess.m_175515_(Registries.f_266076_);
        Registry patternRegistry = registryAccess.m_175515_(Registries.f_266063_);
        return new Pair((Object)materialRegistry, (Object)patternRegistry);
    }

    protected static List<Holder.Reference<TrimPattern>> getPatterns(Registry<TrimPattern> patternRegistry) {
        return new ArrayList<Holder.Reference<TrimPattern>>(patternRegistry.m_203611_().toList());
    }

    @Nullable
    private static ArmorTrim getPredefinedTrim(RegistryAccess registryAccess) {
        List<TrimData> predefinedTrims = Config.CONFIG_MANAGER.instance().trimMobs.predefinedTrims;
        Collections.shuffle(predefinedTrims);
        Iterator<TrimData> iterator = predefinedTrims.iterator();
        if (iterator.hasNext()) {
            TrimData predefinedTrim = iterator.next();
            try {
                return predefinedTrim.getTrim(registryAccess);
            }
            catch (NoSuchElementException | ResourceLocationException e) {
                return null;
            }
        }
        return null;
    }
}

