/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.mixin;

import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimApplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractVillager.class})
public abstract class VillagerTradesMixin
extends Mob {
    protected VillagerTradesMixin(EntityType<? extends Mob> arg, Level arg2) {
        super(arg, arg2);
    }

    @Inject(method={"addOffersFromItemListings"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/trading/MerchantOffers;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void trimTrades(MerchantOffers merchantOffers, VillagerTrades.ItemListing[] itemListings, int i, CallbackInfo ci) {
        VillagerDataHolder dataHolder;
        if (!Config.CONFIG_MANAGER.instance().enableTrimTrades) {
            return;
        }
        int minLevel = Config.CONFIG_MANAGER.instance().trimTrades.minLevel;
        VillagerTradesMixin villagerTradesMixin = this;
        if (villagerTradesMixin instanceof VillagerDataHolder && (dataHolder = (VillagerDataHolder)villagerTradesMixin).m_7141_().m_35576_() < minLevel) {
            return;
        }
        int trimChance = Config.CONFIG_MANAGER.instance().trimTrades.trimChance;
        if (trimChance < this.f_19796_.m_188503_(100)) {
            return;
        }
        ItemStack trade = ((MerchantOffer)merchantOffers.get(merchantOffers.size() - 1)).m_45368_();
        if (!trade.m_204117_(ItemTags.f_265942_) && !trade.m_204117_(ToolTrimsCompat.TRIMMABLE_TOOLS_TAG)) {
            return;
        }
        RandomSource random = this.m_217043_();
        RegistryAccess registryAccess = this.m_9236_().m_9598_();
        ArmorTrim trim = TrimApplier.getRandomTrim(registryAccess, random);
        if (trim == null) {
            return;
        }
        if (trade.m_204117_(ItemTags.f_265942_)) {
            TrimApplier.applyTrim(trade, trim, registryAccess);
        } else {
            ToolTrimsCompat.applyTrimToTool(trade, (Holder<TrimMaterial>)trim.m_266210_(), registryAccess, random);
        }
    }
}

