/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.majo24.naturally_trimmed.RegistryHelper;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimApplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class TrimLootTablesFunction
extends LootItemConditionalFunction {
    protected TrimLootTablesFunction(LootItemCondition[] predicates) {
        super(predicates);
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)RegistryHelper.TRIM_LOOT_TABLES_FUNCTION.get();
    }

    @NotNull
    protected ItemStack m_7372_(ItemStack itemStack, @NotNull LootContext lootContext) {
        if (!Config.CONFIG_MANAGER.instance().enableTrimLootTables) {
            return itemStack;
        }
        if (!itemStack.m_204117_(ItemTags.f_265942_) && !itemStack.m_204117_(ToolTrimsCompat.TRIMMABLE_TOOLS_TAG)) {
            return itemStack;
        }
        RandomSource random = lootContext.m_230907_();
        RegistryAccess registryAccess = lootContext.m_78952_().m_9598_();
        if (Config.CONFIG_MANAGER.instance().trimLootTables.trimChance < random.m_188503_(100)) {
            return itemStack;
        }
        ArmorTrim trim = TrimApplier.getRandomTrim(registryAccess, random);
        if (trim == null) {
            return itemStack;
        }
        if (itemStack.m_204117_(ItemTags.f_265942_)) {
            TrimApplier.applyTrim(itemStack, trim, registryAccess);
        } else {
            ToolTrimsCompat.applyTrimToTool(itemStack, (Holder<TrimMaterial>)trim.m_266210_(), registryAccess, random);
        }
        return itemStack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return TrimLootTablesFunction.m_80683_(TrimLootTablesFunction::new);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<TrimLootTablesFunction> {
        @NotNull
        public TrimLootTablesFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            return new TrimLootTablesFunction(conditions);
        }
    }
}

