/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_application.TrimData;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3489;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TrimApplier {
    private TrimApplier() {
    }

    public static void applyTrim(class_1799 itemStack, class_8053 armorTrim, class_5455 registryAccess) {
        itemStack.method_57366(class_9326.method_57841().method_57854(class_9334.field_49607, (Object)armorTrim).method_57852());
    }

    public static class_8053 getRandomTrim(class_5455 registryAccess, class_5819 random) {
        class_6880.class_6883 trimPattern;
        class_6880.class_6883 trimMaterial;
        Pair<class_2378<class_8054>, class_2378<class_8056>> registries = TrimApplier.getTrimRegistries(registryAccess);
        List<class_6880.class_6883<class_8056>> trimPatterns = TrimApplier.getPatterns((class_2378<class_8056>)((class_2378)registries.getSecond()));
        trimPatterns.removeIf(pattern -> pattern.method_40237().method_29177().method_12836().equals("tooltrims"));
        do {
            trimPattern = (class_6880.class_6883)class_156.method_32309(trimPatterns, (class_5819)random);
        } while (!(trimMaterial = (class_6880.class_6883)((class_2378)registries.getFirst()).method_10240(random).orElseThrow()).method_40237().method_29177().method_12836().equals("minecraft") && !trimPattern.method_40237().method_29177().method_12836().equals("minecraft"));
        return new class_8053((class_6880)trimMaterial, (class_6880)trimPattern);
    }

    public static void trimEquipment(class_1309 entity) {
        class_8053 trim;
        if (!Config.CONFIG_MANAGER.instance().enableTrimMobs) {
            return;
        }
        if (Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance >= entity.method_59922().method_43048(100)) {
            return;
        }
        List<class_1799> armor = StreamSupport.stream(entity.method_5661().spliterator(), false).filter(armorPiece -> !armorPiece.method_7960() && armorPiece.method_31573(class_3489.field_41890)).toList();
        class_5819 random = entity.method_59922();
        class_5455 registryAccess = entity.method_37908().method_30349();
        Config.TrimMobsSubConfig.TrimSystem enabledSystem = Config.CONFIG_MANAGER.instance().trimMobs.trimSystem;
        class_8053 class_80532 = trim = enabledSystem == Config.TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS ? TrimApplier.getRandomTrim(registryAccess, random) : TrimApplier.getPredefinedTrim(registryAccess);
        if (trim == null) {
            return;
        }
        for (class_1799 armorPiece2 : armor) {
            if (Config.CONFIG_MANAGER.instance().trimMobs.trimChance < random.method_43048(100)) continue;
            TrimApplier.applyTrim(armorPiece2, trim, registryAccess);
        }
        if ((NaturallyTrimmed.isModLoaded("tooltrims") || NaturallyTrimmed.isModLoaded("trimmable_tools")) && Config.CONFIG_MANAGER.instance().trimMobs.trimChance >= random.method_43048(100)) {
            ToolTrimsCompat.applyTrimToTool(entity.method_6047(), (class_6880<class_8054>)trim.method_48431(), registryAccess, random);
        }
    }

    protected static Pair<class_2378<class_8054>, class_2378<class_8056>> getTrimRegistries(class_5455 registryAccess) {
        class_2378 materialRegistry = registryAccess.method_30530(class_7924.field_42083);
        class_2378 patternRegistry = registryAccess.method_30530(class_7924.field_42082);
        return new Pair((Object)materialRegistry, (Object)patternRegistry);
    }

    protected static List<class_6880.class_6883<class_8056>> getPatterns(class_2378<class_8056> patternRegistry) {
        return new ArrayList<class_6880.class_6883<class_8056>>(patternRegistry.method_40270().toList());
    }

    @Nullable
    private static class_8053 getPredefinedTrim(class_5455 registryAccess) {
        List<TrimData> predefinedTrims = Config.CONFIG_MANAGER.instance().trimMobs.predefinedTrims;
        Collections.shuffle(predefinedTrims);
        Iterator<TrimData> iterator = predefinedTrims.iterator();
        if (iterator.hasNext()) {
            TrimData predefinedTrim = iterator.next();
            try {
                return predefinedTrim.getTrim(registryAccess);
            }
            catch (NoSuchElementException | class_151 e) {
                return null;
            }
        }
        return null;
    }
}

