/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config.screen;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_combination.TrimCombination;
import net.majo24.naturally_trimmed.trim_combination.TrimKey;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class SettingsValidation {
    private SettingsValidation() {
    }

    public static void validateTrimCombinations() {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || player == null) {
            return;
        }
        class_5455 registryAccess = level.method_30349();
        player.method_7353((class_2561)class_2561.method_43470((String)"Validating custom trim combinations...\n"), false);
        int index = 0;
        for (TrimCombination trimCombination : Config.CONFIG_MANAGER.instance().trimMobs.trimCombinations) {
            SettingsValidation.validateTrimCombination(trimCombination, registryAccess, player, index);
            ++index;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"\nDone validating custom trim combinations"), false);
    }

    private static void validateTrimCombination(TrimCombination trimCombination, class_5455 registryAccess, class_746 player, int index) {
        for (TrimKey trim : trimCombination.trims()) {
            if (trim.getTrim(registryAccess) != null) continue;
            player.method_7353((class_2561)class_2561.method_43470((String)("Found invalid trim: \"" + String.valueOf(trim) + "\" in trim combination " + index)), false);
        }
    }

    public static void validateBlacklist() {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || player == null) {
            return;
        }
        class_2378 patternRegistry = level.method_30349().method_30530(class_7924.field_42082);
        ArrayList trimPatternsList = new ArrayList(patternRegistry.method_40270().toList());
        Map<String, Boolean> trimPatterns = trimPatternsList.stream().collect(Collectors.toMap(trimPattern -> trimPattern.method_40237().method_29177().toString(), trimPattern -> false));
        Map<Pattern, Boolean> blacklist = Config.CONFIG_MANAGER.instance().blacklist.stream().collect(Collectors.toMap(pattern -> pattern, pattern -> false));
        player.method_7353((class_2561)class_2561.method_43470((String)"Validating blacklist...\n"), false);
        player.method_7353((class_2561)class_2561.method_43470((String)"Checking for blacklisted trim patterns\n"), false);
        for (Map.Entry<Pattern, Boolean> entry : blacklist.entrySet()) {
            for (Map.Entry<String, Boolean> trimPattern2 : trimPatterns.entrySet()) {
                if (!entry.getKey().matcher(trimPattern2.getKey()).find()) continue;
                entry.setValue(true);
                trimPattern2.setValue(true);
                player.method_7353((class_2561)class_2561.method_43470((String)("Regex pattern \"" + String.valueOf(entry.getKey()) + "\" blacklists trim pattern \"" + trimPattern2.getKey() + "\"")), false);
            }
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"\nChecking for not blacklisted trim patterns\n"), false);
        for (Map.Entry<Object, Boolean> entry : trimPatterns.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            player.method_7353((class_2561)class_2561.method_43470((String)("Trim pattern \"" + (String)entry.getKey() + "\" is not blacklisted")), false);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"\nChecking for unnecessary regex patterns\n"), false);
        for (Map.Entry<Object, Boolean> entry : blacklist.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            player.method_7353((class_2561)class_2561.method_43470((String)("Regex pattern \"" + String.valueOf(entry.getKey()) + "\" does not blacklist any registered trim pattern.")), false);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"\nDone validating blacklist"), false);
    }
}

