/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config.screen;

import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.Objects;
import java.util.regex.Pattern;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.config.TrimMobsSubConfig;
import net.majo24.naturally_trimmed.config.screen.SettingsValidation;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen {
    public static final Formatters.Percentage percentageFormatter = new Formatters.Percentage();
    public static final Formatters.TrimSystem trimSystemFormatter = new Formatters.TrimSystem();

    private ConfigScreen() {
    }

    public static Screen getConfigScreen(Screen parent) {
        YetAnotherConfigLib.Builder configScreen = YetAnotherConfigLib.createBuilder().title((Component)Component.literal((String)"Naturally Trimmed")).save(Config.CONFIG_MANAGER::saveInstance).category(ConfigScreen.buildGeneralCategory()).category(ConfigScreen.buildUtilsCategory());
        return configScreen.build().generateScreen(parent);
    }

    private static ConfigCategory buildGeneralCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.general")).tooltip(new Component[]{Component.translatable((String)"naturally_trimmed.config.general.tooltip")}).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimMobs")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimMobs.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimMobs, () -> Config.CONFIG_MANAGER.instance().enableTrimMobs, enableTrimMobs -> {
            Config.CONFIG_MANAGER.instance().enableTrimMobs = enableTrimMobs;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimLootTables")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimLootTables.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimLootTables, () -> Config.CONFIG_MANAGER.instance().enableTrimLootTables, enableTrimLootTables -> {
            Config.CONFIG_MANAGER.instance().enableTrimLootTables = enableTrimLootTables;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimTrades")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.enable_features.enableTrimTrades.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().enableTrimTrades, () -> Config.CONFIG_MANAGER.instance().enableTrimTrades, enableTrimTrades -> {
            Config.CONFIG_MANAGER.instance().enableTrimTrades = enableTrimTrades;
        }).controller(BooleanControllerBuilder::create).build()).build()).group(ConfigScreen.buildTrimMobsGroup()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimLootTables")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimLootTables.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimLootTables.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimLootTables.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimLootTables.trimChance, () -> Config.CONFIG_MANAGER.instance().trimLootTables.trimChance, trimChance -> {
            Config.CONFIG_MANAGER.instance().trimLootTables.trimChance = trimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).build()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimTrades")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimTrades.description")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimTrades.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimTrades.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimTrades.trimChance, () -> Config.CONFIG_MANAGER.instance().trimTrades.trimChance, trimChance -> {
            Config.CONFIG_MANAGER.instance().trimTrades.trimChance = trimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimTrades.minLevel")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimTrades.minLevel.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimTrades.minLevel, () -> Config.CONFIG_MANAGER.instance().trimTrades.minLevel, minLevel -> {
            Config.CONFIG_MANAGER.instance().trimTrades.minLevel = minLevel;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)1, (Number)5)).step((Number)1)).build()).build()).group((OptionGroup)ListOption.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.blacklist")).collapsed(true).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.blacklist.description")})).binding(Config.CONFIG_MANAGER.defaults().blacklist.stream().map(Pattern::pattern).toList(), () -> Config.CONFIG_MANAGER.instance().blacklist.stream().map(Pattern::pattern).toList(), blacklist -> {
            Config.CONFIG_MANAGER.instance().blacklist = blacklist.stream().map(Pattern::compile).toList();
        }).controller(StringControllerBuilder::create).initial((Object)"").build()).build();
    }

    private static OptionGroup buildTrimMobsGroup() {
        return OptionGroup.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.tooltip")})).collapsed(true).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.trimSystem")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.trimSystem.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.trimSystem, () -> Config.CONFIG_MANAGER.instance().trimMobs.trimSystem, enabledSystem -> {
            Config.CONFIG_MANAGER.instance().trimMobs.trimSystem = enabledSystem;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(TrimMobsSubConfig.TrimSystem.class).formatValue((ValueFormatter)trimSystemFormatter)).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.noTrimsChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.noTrimsChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.noTrimsChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance, noTrimsChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance = noTrimsChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option((Option)LabelOption.create((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.randomTrims.description"))).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.randomTrims.trimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.randomTrims.trimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.randomTrims.trimChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance, trimsChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance = trimsChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.trimMobs.randomTrims.similarTrimChance")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.trimMobs.randomTrims.similarTrimChance.description")})).binding((Object)Config.CONFIG_MANAGER.defaults().trimMobs.randomTrims.similarTrimChance, () -> Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance, similarTrimChance -> {
            Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance = similarTrimChance;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue((ValueFormatter)percentageFormatter)).build()).build();
    }

    private static ConfigCategory buildUtilsCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils")).tooltip(new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.tooltip")}).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils.reloadConfig")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.reloadConfig.description")})).action((screen, option) -> {
            Config.CONFIG_MANAGER.loadInstance();
            screen.onClose();
        }).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils.validateCustomTrimCombinations")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.validateCustomTrimCombinations.description")})).action((screen, option) -> SettingsValidation.validateTrimCombinations()).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"naturally_trimmed.config.utils.validateBlacklist")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"naturally_trimmed.config.utils.validateBlacklist.description")})).action((screen, option) -> SettingsValidation.validateBlacklist()).build()).build();
    }

    public static class Formatters {
        private Formatters() {
        }

        public static class TrimSystem
        implements ValueFormatter<TrimMobsSubConfig.TrimSystem> {
            public Component format(TrimMobsSubConfig.TrimSystem selectedSystem) {
                return switch (selectedSystem) {
                    default -> throw new IncompatibleClassChangeError();
                    case TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS -> Component.literal((String)"Random Trims");
                    case TrimMobsSubConfig.TrimSystem.CUSTOM_TRIM_COMBINATIONS -> Component.literal((String)"Custom Trim Combinations");
                };
            }
        }

        public static class Percentage
        implements ValueFormatter<Integer> {
            public Component format(Integer value) {
                return Component.literal((String)(value.toString() + "%"));
            }
        }
    }

    static class BackupScreen
    extends OptionsSubScreen {
        public BackupScreen(Screen parent) {
            super(parent, Minecraft.getInstance().options, (Component)Component.literal((String)"Naturally Trimmed"));
        }

        public void init() {
            MultiLineTextWidget messageWidget = new MultiLineTextWidget(this.width / 2 - 110, this.height / 2 - 40, (Component)Component.translatable((String)"naturally_trimmed.config.backup_screen.installYACL"), Objects.requireNonNull(this.minecraft).font);
            messageWidget.setMaxWidth(240);
            messageWidget.setCentered(true);
            this.addRenderableWidget((GuiEventListener)messageWidget);
            Button openLinkButton = Button.builder((Component)Component.translatable((String)"naturally_trimmed.config.backup_screen.viewOnModrinth"), button -> this.minecraft.setScreen((Screen)new ConfirmLinkScreen(open -> {
                if (open) {
                    Util.getPlatform().openUri("https://modrinth.com/mod/yacl");
                }
                this.minecraft.setScreen(this.lastScreen);
            }, "https://modrinth.com/mod/yacl", true))).pos(this.width / 2 - 120, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)openLinkButton);
            Button exitButton = Button.builder((Component)CommonComponents.GUI_OK, button -> this.onClose()).pos(this.width / 2 + 5, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)exitButton);
        }

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            super.render(graphics, mouseX, mouseY, delta);
            graphics.drawCenteredString(this.font, this.title, this.width / 2, 5, 0xFFFFFF);
        }
    }
}

