/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config.screen;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.trim_combination.TrimCombination;
import net.majo24.naturally_trimmed.trim_combination.TrimKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;

public class SettingsValidation {
    private SettingsValidation() {
    }

    public static void validateTrimCombinations() {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || player == null) {
            return;
        }
        RegistryAccess registryAccess = level.registryAccess();
        player.displayClientMessage((Component)Component.literal((String)"Validating custom trim combinations...\n"), false);
        int index = 0;
        for (TrimCombination trimCombination : Config.CONFIG_MANAGER.instance().trimMobs.trimCombinations) {
            SettingsValidation.validateTrimCombination(trimCombination, registryAccess, player, index);
            ++index;
        }
        player.displayClientMessage((Component)Component.literal((String)"\nDone validating custom trim combinations"), false);
    }

    private static void validateTrimCombination(TrimCombination trimCombination, RegistryAccess registryAccess, LocalPlayer player, int index) {
        for (TrimKey trim : trimCombination.trims()) {
            if (trim.getTrim(registryAccess) != null) continue;
            player.displayClientMessage((Component)Component.literal((String)("Found invalid trim: \"" + String.valueOf(trim) + "\" in trim combination " + index)), false);
        }
    }

    public static void validateBlacklist() {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || player == null) {
            return;
        }
        Registry patternRegistry = level.registryAccess().registryOrThrow(Registries.TRIM_PATTERN);
        ArrayList trimPatternsList = new ArrayList(patternRegistry.holders().toList());
        Map<String, Boolean> trimPatterns = trimPatternsList.stream().collect(Collectors.toMap(trimPattern -> trimPattern.key().location().toString(), trimPattern -> false));
        Map<Pattern, Boolean> blacklist = Config.CONFIG_MANAGER.instance().blacklist.stream().collect(Collectors.toMap(pattern -> pattern, pattern -> false));
        player.displayClientMessage((Component)Component.literal((String)"Validating blacklist...\n"), false);
        player.displayClientMessage((Component)Component.literal((String)"Checking for blacklisted trim patterns\n"), false);
        for (Map.Entry<Pattern, Boolean> entry : blacklist.entrySet()) {
            for (Map.Entry<String, Boolean> trimPattern2 : trimPatterns.entrySet()) {
                if (!entry.getKey().matcher(trimPattern2.getKey()).find()) continue;
                entry.setValue(true);
                trimPattern2.setValue(true);
                player.displayClientMessage((Component)Component.literal((String)("Regex pattern \"" + String.valueOf(entry.getKey()) + "\" blacklists trim pattern \"" + trimPattern2.getKey() + "\"")), false);
            }
        }
        player.displayClientMessage((Component)Component.literal((String)"\nChecking for not blacklisted trim patterns\n"), false);
        for (Map.Entry<Object, Boolean> entry : trimPatterns.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            player.displayClientMessage((Component)Component.literal((String)("Trim pattern \"" + (String)entry.getKey() + "\" is not blacklisted")), false);
        }
        player.displayClientMessage((Component)Component.literal((String)"\nChecking for unnecessary regex patterns\n"), false);
        for (Map.Entry<Object, Boolean> entry : blacklist.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            player.displayClientMessage((Component)Component.literal((String)("Regex pattern \"" + String.valueOf(entry.getKey()) + "\" does not blacklist any registered trim pattern.")), false);
        }
        player.displayClientMessage((Component)Component.literal((String)"\nDone validating blacklist"), false);
    }
}

