/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config;

import java.util.ArrayList;
import java.util.List;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.backend.ConfigManager;
import net.majo24.naturally_trimmed.config.backend.annotations.Entry;
import net.majo24.naturally_trimmed.config.backend.annotations.SubConfig;
import net.majo24.naturally_trimmed.trim_application.TrimData;

public class Config {
    public static final ConfigManager<Config> CONFIG_MANAGER = new ConfigManager<Config>(Config.class, NaturallyTrimmed.getConfigPath());
    @Entry(name="enable_trim_mobs", comment="Enables the equipment from mobs to be trimmed")
    public boolean enableTrimMobs = true;
    @Entry(name="enable_trim_loot_tables", comment="Enables the equipment generated by loot tables to be trimmed")
    public boolean enableTrimLootTables = true;
    @Entry(name="enable_trim_trades", comment="Enables the equipment from villager trades to be trimmed")
    public boolean enableTrimTrades = true;
    @SubConfig(name="trim_mobs", comment="Settings for trimming a mob's equipment")
    public TrimMobsSubConfig trimMobs = new TrimMobsSubConfig();
    @SubConfig(name="trim_loot_tables", comment="Settings for trimming equipment generated by loot tables")
    public TrimLootTablesSubConfig trimLootTables = new TrimLootTablesSubConfig();
    @SubConfig(name="trim_trades", comment="Settings for trimming equipment from villager trades")
    public TrimTradesSubConfig trimTrades = new TrimTradesSubConfig();

    public static class TrimMobsSubConfig {
        @Entry(name="trim_system", comment="Select the trim system. Trim systems define how the mod chooses what trims to use.\n- RANDOM_TRIMS: Randomly chooses the trim to apply to the mob.\n- PREDEFINED_TRIMS: Chooses the trim from a list of predefined trims. You can manage the list of trims under the predefined_trims config entry.")
        public TrimSystem trimSystem = TrimSystem.RANDOM_TRIMS;
        @Entry(name="no_trims_chance", comment="Chance of the mob having no trims at all")
        public int noTrimsChance = 25;
        @Entry(name="trim_chance", comment="Chance of each individual armor piece having a trim")
        public int trimChance = 75;
        @Entry(name="predefined_trims", comment="List of predefined trims.\n\nA predefined trim consists of a trim material and a trim pattern.\n\nExample-Configuration:\npredefined_trims: [{material: \"resin\", pattern: \"silence\"}, {material: \"netherite\", pattern: \"vex\"}, {material: \"minecraft:amethyst\", pattern: \"minecraft:silence\"}]\n")
        public List<TrimData> predefinedTrims = new ArrayList<TrimData>();

        public static enum TrimSystem {
            RANDOM_TRIMS,
            PREDEFINED_TRIMS;

        }
    }

    public static class TrimLootTablesSubConfig {
        @Entry(name="trim_chance", comment="Chance of an item generated by a loot table of having a trim applied")
        public int trimChance = 50;
    }

    public static class TrimTradesSubConfig {
        @Entry(name="trim_chance", comment="Chance of a villager trade of having a trim applied")
        public int trimChance = 50;
        @Entry(name="min_level", comment="The minimum villager trading level an item needs to be in, to have a chance of being trimmed")
        public int minLevel = 3;
    }
}

