/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_application;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.config.TrimMobsSubConfig;
import net.majo24.naturally_trimmed.trim_application.ToolTrimsCompat;
import net.majo24.naturally_trimmed.trim_combination.TrimCombination;
import net.majo24.naturally_trimmed.trim_combination.TrimKey;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TrimApplier {
    private TrimApplier() {
    }

    public static void trimEquipment(class_1309 entity) {
        if (!Config.CONFIG_MANAGER.instance().enableTrimMobs) {
            return;
        }
        List<class_1799> armor = StreamSupport.stream(entity.method_5661().spliterator(), false).filter(armorPiece -> !armorPiece.method_7960() && armorPiece.method_31573(class_3489.field_41890)).toList();
        class_5819 random = entity.method_59922();
        if (Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance < random.method_43048(100)) {
            if (!armor.isEmpty()) {
                TrimApplier.applyTrims(entity.method_37908().method_30349(), random, armor);
            }
            if ((NaturallyTrimmed.isModLoaded("tooltrims") || NaturallyTrimmed.isModLoaded("trimmable_tools")) && Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance >= random.method_43048(100)) {
                ToolTrimsCompat.toolTrimsCompat(entity.method_6047(), entity.method_37908().method_30349(), entity.method_59922());
            }
        }
    }

    public static void applyTrims(class_5455 registryAccess, class_5819 random, List<class_1799> armor) {
        TrimMobsSubConfig.TrimSystem enabledSystem = Config.CONFIG_MANAGER.instance().trimMobs.trimSystem;
        if (enabledSystem == TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS) {
            TrimApplier.runRandomTrimsSystem(registryAccess, random, armor);
        } else {
            TrimApplier.runCustomTrimCombinationsSystem(armor, registryAccess);
        }
    }

    public static void runRandomTrimsSystem(class_5455 registryAccess, class_5819 random, Iterable<class_1799> armor) {
        Pair<class_2378<class_8054>, class_2378<class_8056>> registries = TrimApplier.getTrimRegistries(registryAccess);
        class_2378 materialRegistry = (class_2378)registries.getFirst();
        class_2378 patternRegistry = (class_2378)registries.getSecond();
        Pair<class_6880.class_6883<class_8054>, class_6880.class_6883<class_8056>> lastTrim = null;
        for (class_1799 armorPiece : armor) {
            if (Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance < random.method_43048(100)) continue;
            lastTrim = TrimApplier.applyRandomTrim(registryAccess, (class_2378<class_8054>)materialRegistry, (class_2378<class_8056>)patternRegistry, random, armorPiece, lastTrim);
        }
    }

    public static Pair<class_2378<class_8054>, class_2378<class_8056>> getTrimRegistries(class_5455 registryAccess) {
        class_5321 materialKey = class_7924.field_42083;
        class_5321 patternKey = class_7924.field_42082;
        class_2378 materialRegistry = registryAccess.method_30530(materialKey);
        class_2378 patternRegistry = registryAccess.method_30530(patternKey);
        return new Pair((Object)materialRegistry, (Object)patternRegistry);
    }

    public static void runCustomTrimCombinationsSystem(List<class_1799> armor, class_5455 registryAccess) {
        String requiredMaterial = TrimApplier.getArmorMaterial(armor.getFirst());
        if (requiredMaterial == null) {
            return;
        }
        TrimCombination trimCombination = TrimCombination.getRandomTrimCombination(requiredMaterial);
        if (trimCombination == null) {
            return;
        }
        Iterator<class_1799> armorIterator = armor.iterator();
        for (TrimKey trim : trimCombination.trims().reversed()) {
            class_1799 armorPiece = armorIterator.next();
            class_8053 armorTrim = TrimCombination.getOrCreateCachedTrim(trim.material(), trim.pattern(), registryAccess);
            if (armorTrim == null) continue;
            TrimApplier.applyTrim(armorPiece, armorTrim, registryAccess);
        }
    }

    @Nullable
    private static String getArmorMaterial(class_1799 armorPiece) {
        for (String material : List.of("netherite", "diamond", "gold", "iron", "chainmail", "copper", "leather")) {
            if (!armorPiece.toString().contains(material)) continue;
            return material;
        }
        NaturallyTrimmed.LOGGER.error("Could not find armor material for {}", (Object)armorPiece);
        return null;
    }

    public static void applyTrim(class_1799 itemStack, class_8053 armorTrim, class_5455 registryAccess) {
        itemStack.method_57366(class_9326.method_57841().method_57854(class_9334.field_49607, (Object)armorTrim).method_57852());
    }

    @Nullable
    public static Pair<class_6880.class_6883<class_8054>, class_6880.class_6883<class_8056>> applyRandomTrim(class_5455 registryAccess, class_2378<class_8054> materialRegistry, class_2378<class_8056> patternRegistry, class_5819 random, class_1799 itemStack, @Nullable Pair<class_6880.class_6883<class_8054>, class_6880.class_6883<class_8056>> referenceTrim) {
        List<class_6880.class_6883<class_8056>> trimPatterns = TrimApplier.getAndFilterPatterns(patternRegistry);
        if (trimPatterns.isEmpty()) {
            return null;
        }
        boolean newMaterial = true;
        class_6880.class_6883 trimMaterial = null;
        boolean newPattern = true;
        class_6880.class_6883 trimPattern = null;
        if (referenceTrim != null) {
            int similarTrimChance = Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance;
            if (similarTrimChance >= random.method_43048(100)) {
                trimMaterial = (class_6880.class_6883)referenceTrim.getFirst();
                newMaterial = false;
            }
            if (similarTrimChance >= random.method_43048(100)) {
                trimPattern = (class_6880.class_6883)referenceTrim.getSecond();
                newPattern = false;
            }
        }
        do {
            if (newPattern) {
                trimPattern = (class_6880.class_6883)class_156.method_32309(trimPatterns, (class_5819)random);
            }
            if (!newMaterial) continue;
            trimMaterial = (class_6880.class_6883)materialRegistry.method_10240(random).orElseThrow();
        } while (!trimMaterial.method_40237().method_29177().method_12836().equals("minecraft") && !trimPattern.method_40237().method_29177().method_12836().equals("minecraft"));
        class_8053 armorTrim = new class_8053((class_6880)trimMaterial, (class_6880)trimPattern);
        TrimApplier.applyTrim(itemStack, armorTrim, registryAccess);
        return new Pair((Object)trimMaterial, (Object)trimPattern);
    }

    private static List<class_6880.class_6883<class_8056>> getAndFilterPatterns(class_2378<class_8056> patternRegistry) {
        List<class_6880.class_6883<class_8056>> trimPatterns = TrimApplier.getPatterns(patternRegistry);
        List<Pattern> patterns = Config.CONFIG_MANAGER.instance().blacklist;
        trimPatterns.removeIf(trimPattern -> {
            String resourceLocation = trimPattern.method_40237().method_29177().toString();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(resourceLocation).find()) continue;
                return true;
            }
            return false;
        });
        return trimPatterns;
    }

    public static List<class_6880.class_6883<class_8056>> getPatterns(class_2378<class_8056> patternRegistry) {
        return new ArrayList<class_6880.class_6883<class_8056>>(patternRegistry.method_42017().toList());
    }

    public static void applyRandomTrimToItem(class_1799 itemStack, class_5455 registryAccess, class_5819 random) {
        Pair<class_2378<class_8054>, class_2378<class_8056>> registries = TrimApplier.getTrimRegistries(registryAccess);
        class_2378 materialRegistry = (class_2378)registries.getFirst();
        class_2378 patternRegistry = (class_2378)registries.getSecond();
        TrimApplier.applyRandomTrim(registryAccess, (class_2378<class_8054>)materialRegistry, (class_2378<class_8056>)patternRegistry, random, itemStack, null);
    }
}

