/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.ToolTrimsCompat;
import net.majo24.naturally_trimmed.config.Config;
import net.majo24.naturally_trimmed.config.TrimMobsSubConfig;
import net.majo24.naturally_trimmed.trim_combination.TrimCombination;
import net.majo24.naturally_trimmed.trim_combination.TrimKey;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class TrimApplier {
    private TrimApplier() {
    }

    public static void trimEquipment(LivingEntity entity) {
        if (!Config.CONFIG_MANAGER.instance().enableTrimMobs) {
            return;
        }
        List<ItemStack> armor = EquipmentSlotGroup.ARMOR.slots().stream().map(arg_0 -> ((LivingEntity)entity).getItemBySlot(arg_0)).filter(armorPiece -> !armorPiece.isEmpty()).toList();
        RandomSource random = entity.getRandom();
        if (Config.CONFIG_MANAGER.instance().trimMobs.noTrimsChance <= random.nextInt(100)) {
            if (!armor.isEmpty()) {
                TrimApplier.applyTrims(entity.level().registryAccess(), random, armor);
            }
            if ((NaturallyTrimmed.isModLoaded("tooltrims") || NaturallyTrimmed.isModLoaded("trimmable_tools")) && Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance >= random.nextInt(100)) {
                ToolTrimsCompat.toolTrimsCompat(entity.getMainHandItem(), entity.level().registryAccess(), entity.getRandom());
            }
        }
    }

    public static void applyTrims(RegistryAccess registryAccess, RandomSource random, List<ItemStack> armor) {
        TrimMobsSubConfig.TrimSystem enabledSystem = Config.CONFIG_MANAGER.instance().trimMobs.trimSystem;
        if (enabledSystem == TrimMobsSubConfig.TrimSystem.RANDOM_TRIMS) {
            TrimApplier.runRandomTrimsSystem(registryAccess, random, armor);
        } else {
            TrimApplier.runCustomTrimCombinationsSystem(armor, registryAccess);
        }
    }

    public static void runRandomTrimsSystem(RegistryAccess registryAccess, RandomSource random, Iterable<ItemStack> armor) {
        Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
        Registry materialRegistry = (Registry)registries.getFirst();
        Registry patternRegistry = (Registry)registries.getSecond();
        ArmorTrim lastTrim = null;
        for (ItemStack armorPiece : armor) {
            if (Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.trimChance < random.nextInt(100)) continue;
            lastTrim = TrimApplier.applyRandomTrim(registryAccess, (Registry<TrimMaterial>)materialRegistry, (Registry<TrimPattern>)patternRegistry, random, armorPiece, lastTrim);
        }
    }

    public static Pair<Registry<TrimMaterial>, Registry<TrimPattern>> getTrimRegistries(RegistryAccess registryAccess) {
        ResourceKey materialKey = Registries.TRIM_MATERIAL;
        ResourceKey patternKey = Registries.TRIM_PATTERN;
        Registry materialRegistry = registryAccess.lookupOrThrow(materialKey);
        Registry patternRegistry = registryAccess.lookupOrThrow(patternKey);
        return new Pair((Object)materialRegistry, (Object)patternRegistry);
    }

    public static void runCustomTrimCombinationsSystem(List<ItemStack> armor, RegistryAccess registryAccess) {
        String requiredMaterial = TrimApplier.getArmorMaterial(armor.getFirst());
        if (requiredMaterial == null) {
            return;
        }
        TrimCombination trimCombination = TrimCombination.getRandomTrimCombination(requiredMaterial);
        if (trimCombination == null) {
            return;
        }
        Iterator<ItemStack> armorIterator = armor.iterator();
        for (TrimKey trim : trimCombination.trims().reversed()) {
            ItemStack armorPiece = armorIterator.next();
            ArmorTrim armorTrim = TrimCombination.getOrCreateCachedTrim(trim.material(), trim.pattern(), registryAccess);
            if (armorTrim == null) continue;
            TrimApplier.applyTrim(armorPiece, armorTrim, registryAccess);
        }
    }

    @Nullable
    private static String getArmorMaterial(ItemStack armorPiece) {
        for (String material : List.of("netherite", "diamond", "gold", "iron", "chainmail", "leather")) {
            if (!armorPiece.toString().contains(material)) continue;
            return material;
        }
        NaturallyTrimmed.LOGGER.error("Could not find armor material for {}", (Object)armorPiece);
        return null;
    }

    public static void applyTrim(ItemStack itemStack, ArmorTrim armorTrim, RegistryAccess registryAccess) {
        itemStack.applyComponents(DataComponentPatch.builder().set(DataComponents.TRIM, (Object)armorTrim).build());
    }

    @Nullable
    public static ArmorTrim applyRandomTrim(RegistryAccess registryAccess, Registry<TrimMaterial> materialRegistry, Registry<TrimPattern> patternRegistry, RandomSource random, ItemStack itemStack, @Nullable ArmorTrim referenceTrim) {
        List<Holder.Reference<TrimPattern>> trimPatterns = TrimApplier.getAndFilterPatterns(patternRegistry);
        if (trimPatterns.isEmpty()) {
            return null;
        }
        Holder.Reference randomTrimMaterial = (Holder.Reference)materialRegistry.getRandom(random).orElseThrow();
        Holder.Reference randomTrimPattern = (Holder.Reference)Util.getRandom(trimPatterns, (RandomSource)random);
        ArmorTrim armorTrim = new ArmorTrim((Holder)randomTrimMaterial, (Holder)randomTrimPattern);
        if (referenceTrim != null) {
            int similarTrimChance = Config.CONFIG_MANAGER.instance().trimMobs.randomTrims.similarTrimChance;
            if (similarTrimChance >= random.nextInt(100)) {
                armorTrim = new ArmorTrim(referenceTrim.material(), armorTrim.pattern());
            }
            if (similarTrimChance >= random.nextInt(100)) {
                armorTrim = new ArmorTrim(armorTrim.material(), referenceTrim.pattern());
            }
        }
        TrimApplier.applyTrim(itemStack, armorTrim, registryAccess);
        return armorTrim;
    }

    private static List<Holder.Reference<TrimPattern>> getAndFilterPatterns(Registry<TrimPattern> patternRegistry) {
        List<Holder.Reference<TrimPattern>> trimPatterns = TrimApplier.getPatterns(patternRegistry);
        List<Pattern> patterns = Config.CONFIG_MANAGER.instance().blacklist;
        trimPatterns.removeIf(trimPattern -> {
            String resourceLocation = trimPattern.key().location().toString();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(resourceLocation).find()) continue;
                return true;
            }
            return false;
        });
        return trimPatterns;
    }

    public static List<Holder.Reference<TrimPattern>> getPatterns(Registry<TrimPattern> patternRegistry) {
        return new ArrayList<Holder.Reference<TrimPattern>>(patternRegistry.listElements().toList());
    }

    public static void applyRandomTrimToItem(ItemStack itemStack, RegistryAccess registryAccess, RandomSource random) {
        Pair<Registry<TrimMaterial>, Registry<TrimPattern>> registries = TrimApplier.getTrimRegistries(registryAccess);
        Registry materialRegistry = (Registry)registries.getFirst();
        Registry patternRegistry = (Registry)registries.getSecond();
        TrimApplier.applyRandomTrim(registryAccess, (Registry<TrimMaterial>)materialRegistry, (Registry<TrimPattern>)patternRegistry, random, itemStack, null);
    }
}

