/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.config.backend;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;
import net.majo24.naturally_trimmed.NaturallyTrimmed;
import net.majo24.naturally_trimmed.config.backend.annotations.Entry;
import net.majo24.naturally_trimmed.config.backend.annotations.SubConfig;
import org.quiltmc.parsers.json.JsonWriter;
import org.quiltmc.parsers.json.gson.GsonReader;
import org.quiltmc.parsers.json.gson.GsonWriter;

public class ConfigManager<T> {
    private T instance;
    private final T defaults;
    private final Path configPath;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Pattern.class, (Object)new PatternTypeAdapter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).serializeNulls().setPrettyPrinting().create();

    public ConfigManager(Class<T> configClass, Path configPath) {
        this.configPath = configPath;
        this.defaults = this.createDefaultInstance(configClass);
        this.instance = this.defaults;
    }

    public T instance() {
        return this.instance;
    }

    public T defaults() {
        return this.defaults;
    }

    public void loadInstance() {
        NaturallyTrimmed.LOGGER.info("Loading Naturally Trimmed config from config file");
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            NaturallyTrimmed.LOGGER.info("Creating new Naturally Trimmed config file with default values.");
            this.saveInstance();
            return;
        }
        try (org.quiltmc.parsers.json.JsonReader jsonReader = org.quiltmc.parsers.json.JsonReader.json5((Path)this.configPath);){
            GsonReader gsonReader = new GsonReader(jsonReader);
            jsonReader.beginObject();
            this.recursivelyDeserialize(jsonReader, gsonReader, this.instance);
            jsonReader.endObject();
        }
        catch (Exception e) {
            NaturallyTrimmed.LOGGER.error("Failed to deserialize the Naturally Trimmed config file. Using the default config instead.", (Throwable)e);
            this.instance = this.defaults;
        }
    }

    private void recursivelyDeserialize(org.quiltmc.parsers.json.JsonReader jsonReader, GsonReader gsonReader, Object config) throws Exception {
        HashMap fieldMap = new HashMap();
        Arrays.stream(config.getClass().getDeclaredFields()).forEach(field -> {
            if (field.isAnnotationPresent(Entry.class)) {
                fieldMap.put(Objects.requireNonNull(field.getAnnotation(Entry.class)).name(), field);
            } else if (field.isAnnotationPresent(SubConfig.class)) {
                fieldMap.put(Objects.requireNonNull(field.getAnnotation(SubConfig.class)).name(), field);
            }
        });
        while (jsonReader.hasNext()) {
            String name = jsonReader.nextName();
            Field field2 = (Field)fieldMap.get(name);
            if (field2 == null) {
                NaturallyTrimmed.LOGGER.warn("Found unknown config field \"{}\" while deserializing config file", (Object)name);
                jsonReader.skipValue();
                continue;
            }
            fieldMap.remove(name);
            this.ensureFieldIsPublic(field2);
            if (field2.isAnnotationPresent(Entry.class)) {
                JsonElement element = (JsonElement)this.gson.fromJson((JsonReader)gsonReader, JsonElement.class);
                if (element.isJsonNull()) {
                    NaturallyTrimmed.LOGGER.warn("Found null value for config field {} while deserializing config file. Using default instead.", (Object)name);
                    continue;
                }
                field2.set(config, this.gson.fromJson(element, field2.getGenericType()));
                continue;
            }
            jsonReader.beginObject();
            this.recursivelyDeserialize(jsonReader, gsonReader, field2.get(config));
            jsonReader.endObject();
        }
    }

    public void saveInstance() {
        NaturallyTrimmed.LOGGER.info("Saving Naturally Trimmed config to file");
        try (StringWriter stringWriter = new StringWriter();){
            JsonWriter jsonWriter = JsonWriter.json5((Writer)stringWriter);
            GsonWriter gsonWriter = new GsonWriter(jsonWriter);
            jsonWriter.beginObject();
            this.recursivelySerialize(jsonWriter, gsonWriter, this.instance);
            jsonWriter.endObject();
            jsonWriter.flush();
            Files.writeString(this.configPath, (CharSequence)stringWriter.toString(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            NaturallyTrimmed.LOGGER.error("Failed to serialize and save Naturally Trimmed config to config file", (Throwable)e);
        }
    }

    private void recursivelySerialize(JsonWriter jsonWriter, GsonWriter gsonWriter, Object config) throws IOException, IllegalAccessException {
        for (Field field : config.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Entry.class)) {
                JsonElement element;
                this.ensureFieldIsPublic(field);
                Entry entry = field.getAnnotation(Entry.class);
                jsonWriter.name(Objects.requireNonNull(entry).name());
                jsonWriter.comment(Objects.requireNonNull(entry).comment());
                try {
                    element = this.gson.toJsonTree(field.get(config), field.getType());
                }
                catch (Exception e) {
                    NaturallyTrimmed.LOGGER.error("Failed to serialize config field \"{}\". Saving as null.", (Object)field.getName(), (Object)e);
                    jsonWriter.nullValue();
                    continue;
                }
                this.gson.toJson(element, (com.google.gson.stream.JsonWriter)gsonWriter);
                continue;
            }
            if (!field.isAnnotationPresent(SubConfig.class)) continue;
            this.ensureFieldIsPublic(field);
            SubConfig subConfig = Objects.requireNonNull(field.getAnnotation(SubConfig.class));
            jsonWriter.name(subConfig.name());
            jsonWriter.comment(subConfig.comment());
            jsonWriter.beginObject();
            this.recursivelySerialize(jsonWriter, gsonWriter, field.get(config));
            jsonWriter.endObject();
        }
    }

    private void ensureFieldIsPublic(Field field) {
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new IllegalStateException("Config field " + field.getName() + " located in " + field.getDeclaringClass().getName() + " is not public.");
        }
    }

    private T createDefaultInstance(Class<T> configClass) {
        Constructor<T> noArgsConstructor;
        try {
            noArgsConstructor = configClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ClassFormatError("Failed to find no-args constructor for config class " + configClass.getName() + "\n" + String.valueOf(e));
        }
        try {
            return noArgsConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ClassFormatError("Failed to load default config for class " + noArgsConstructor.getDeclaringClass().getName() + "\n" + String.valueOf(e));
        }
    }

    public static class PatternTypeAdapter
    implements JsonSerializer<Pattern>,
    JsonDeserializer<Pattern> {
        public JsonElement serialize(Pattern src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.pattern());
        }

        public Pattern deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Pattern.compile(json.getAsString());
        }
    }
}

