/*
 * Decompiled with CFR 0.152.
 */
package net.majo24.naturally_trimmed.trim_combination;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public record TrimKey(String material, String pattern) {
    private static final String TRIM_PATTERN_SUFFIX = "_armor_trim_smithing_template";

    @Nullable
    public ArmorTrim getTrim(RegistryAccess registryAccess) {
        Holder<TrimMaterial> trimMaterial = this.getMaterial(this.material, registryAccess);
        if (trimMaterial == null) {
            return null;
        }
        Holder<TrimPattern> trimPattern = this.getPattern(this.pattern, registryAccess);
        if (trimPattern == null && (trimPattern = this.getPattern(this.pattern + TRIM_PATTERN_SUFFIX, registryAccess)) == null) {
            return null;
        }
        return new ArmorTrim(trimMaterial, trimPattern);
    }

    @Nullable
    private Holder<TrimMaterial> getMaterial(String material, RegistryAccess registryAccess) {
        try {
            ItemStack materialItem = this.getItemFromId(material);
            return (Holder)TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)materialItem).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private Holder<TrimPattern> getPattern(String pattern, RegistryAccess registryAccess) {
        try {
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)pattern);
            return (Holder)registryAccess.lookupOrThrow(Registries.TRIM_PATTERN).listElements().filter(reference -> reference.key().location().equals((Object)resourceLocation)).findFirst().orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    private ItemStack getItemFromId(String id) {
        return ((Item)((Holder.Reference)BuiltInRegistries.ITEM.get(Objects.requireNonNull(ResourceLocation.tryParse((String)id))).orElseThrow()).value()).getDefaultInstance();
    }
}

