/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.commands;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.AnimationUtils;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import com.FiveDollaGobby.WelcomeMessages.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class WelcomeCommand
implements CommandExecutor,
TabCompleter {
    private final WelcomePlugin plugin;
    private final Map<UUID, Long> commandCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Map<String, Long>> commandRateLimits = new HashMap<UUID, Map<String, Long>>();
    private final Map<String, Integer> commandCooldownTimes = new HashMap<String, Integer>();

    public WelcomeCommand(WelcomePlugin plugin) {
        this.plugin = plugin;
        this.initializeRateLimits();
    }

    private void initializeRateLimits() {
        this.commandCooldownTimes.put("test", 2);
        this.commandCooldownTimes.put("testall", 5);
        this.commandCooldownTimes.put("testanim", 3);
        this.commandCooldownTimes.put("testtheme", 3);
        this.commandCooldownTimes.put("testmilestone", 2);
        this.commandCooldownTimes.put("testplaytime", 2);
        this.commandCooldownTimes.put("stats", 1);
        this.commandCooldownTimes.put("reset", 10);
        this.commandCooldownTimes.put("toggle", 5);
        this.commandCooldownTimes.put("reload", 30);
    }

    private boolean checkRateLimit(CommandSender sender, String command) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        if (player.hasPermission("welcome.effects.bypass")) {
            return true;
        }
        int cooldownTime = this.commandCooldownTimes.getOrDefault(command, 1);
        long currentTime = System.currentTimeMillis();
        Map playerLimits = this.commandRateLimits.computeIfAbsent(uuid, k -> new HashMap());
        Long lastUsed = (Long)playerLimits.get(command);
        if (lastUsed != null && currentTime - lastUsed < (long)cooldownTime * 1000L) {
            long remaining = (long)cooldownTime * 1000L - (currentTime - lastUsed);
            MessageUtils.sendMessage(sender, "&cPlease wait &e" + (remaining / 1000L + 1L) + " &cseconds before using this command again!");
            return false;
        }
        playerLimits.put(command, currentTime);
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "test": {
                this.handleTest(sender, args);
                break;
            }
            case "testall": {
                this.handleTestAll(sender, args);
                break;
            }
            case "testanim": {
                this.handleTestAnim(sender, args);
                break;
            }
            case "testtheme": {
                this.handleTestTheme(sender, args);
                break;
            }
            case "testmilestone": {
                this.handleTestMilestone(sender, args);
                break;
            }
            case "testplaytime": {
                this.handleTestPlaytime(sender, args);
                break;
            }
            case "stats": {
                this.handleStats(sender, args);
                break;
            }
            case "reset": {
                this.handleReset(sender, args);
                break;
            }
            case "toggle": {
                this.handleToggle(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            default: {
                MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.unknown-command"));
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission("welcome.use")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.help.header"));
        List commands = this.plugin.getMessagesConfig().getStringList("commands.help.commands");
        for (String cmd : commands) {
            if (cmd.contains("reload") && !sender.hasPermission("welcome.reload") || cmd.contains("test") && !sender.hasPermission("welcome.test") || cmd.contains("stats") && !sender.hasPermission("welcome.stats") || cmd.contains("reset") && !sender.hasPermission("welcome.reset")) continue;
            MessageUtils.sendMessage(sender, cmd);
        }
        MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.help.footer"));
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("welcome.reload")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (!this.checkRateLimit(sender, "reload")) {
            return;
        }
        try {
            this.plugin.reload();
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.reload-success"));
        }
        catch (Exception e) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.reload-error"));
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
        }
    }

    private void handleTest(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (!this.checkRateLimit(sender, "test")) {
            return;
        }
        if (args.length > 1) {
            String playerName = SecurityUtils.sanitizePlayerName(args[1]);
            if (playerName == null) {
                MessageUtils.sendMessage(sender, "&cInvalid player name format!");
                return;
            }
            target = Bukkit.getPlayer((String)playerName);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", SecurityUtils.sanitizeText(playerName)));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(target);
        String joinMessage = this.plugin.getMessageManager().getJoinMessage(target, isFirstJoin);
        MessageUtils.sendMessage(sender, "&6Testing join message for &e" + target.getName() + "&6:");
        MessageUtils.sendMessage(sender, joinMessage);
        String quitMessage = this.plugin.getMessageManager().getQuitMessage(target);
        MessageUtils.sendMessage(sender, "&6Quit message:");
        MessageUtils.sendMessage(sender, quitMessage);
        if (sender.equals((Object)target)) {
            MessageUtils.sendMessage(sender, "&6Testing effects in 2 seconds...");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.plugin.getEffectManager().sendTitle(target, isFirstJoin);
                this.plugin.getEffectManager().playJoinSound(target, isFirstJoin);
                this.plugin.getEffectManager().playJoinParticles(target, isFirstJoin);
            }, 40L);
        }
    }

    private void handleTestAll(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", args[1]));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6&l=== WelcomeMessages Feature Showcase ===");
        MessageUtils.sendMessage(sender, "&7Testing all features for: &e" + target.getName());
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l1. Basic Messages:");
        boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(target);
        String joinMessage = this.plugin.getMessageManager().getJoinMessage(target, isFirstJoin);
        String quitMessage = this.plugin.getMessageManager().getQuitMessage(target);
        MessageUtils.sendMessage(sender, "&7Join: " + joinMessage);
        MessageUtils.sendMessage(sender, "&7Quit: " + quitMessage);
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l2. RGB & Gradient Text:");
        MessageUtils.sendMessage(sender, "&7Basic RGB: &#FF6B6BHello &#4ECDC4World &#45B7D1Test");
        MessageUtils.sendMessage(sender, "&7Gradient: <gradient:#FF6B6B:#4ECDC4>Welcome to our server!</gradient>");
        MessageUtils.sendMessage(sender, "&7Rainbow: <rainbow>This is rainbow text!</rainbow>");
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l2.5. Animation System:");
        if (this.plugin.getConfig().getBoolean("animations.enabled", true)) {
            MessageUtils.sendMessage(sender, "&7Animations enabled! Available types:");
            MessageUtils.sendMessage(sender, "&7- &etyping &7- Character by character reveal");
            MessageUtils.sendMessage(sender, "&7- &efade &7- Fade in effect");
            MessageUtils.sendMessage(sender, "&7- &eslide &7- Slide in from side");
            MessageUtils.sendMessage(sender, "&7- &ewave &7- Wave up and down");
            MessageUtils.sendMessage(sender, "&7- &erainbow &7- Rainbow color cycling");
            MessageUtils.sendMessage(sender, "&7- &eglitch &7- Glitch effect");
            MessageUtils.sendMessage(sender, "&7- &etypewriter &7- Typewriter with cursor");
            MessageUtils.sendMessage(sender, "&7- &ebounce &7- Bounce up and down");
            MessageUtils.sendMessage(sender, "&7- &eshake &7- Shake left and right");
            MessageUtils.sendMessage(sender, "&7- &epulse &7- Pulse brightness");
            MessageUtils.sendMessage(sender, "&7- &ematrix &7- Matrix-style falling characters");
            MessageUtils.sendMessage(sender, "&7- &escramble &7- Scramble and reveal");
            if (this.plugin.getConfig().getBoolean("animations.multi-layer.enabled", true)) {
                MessageUtils.sendMessage(sender, "");
                MessageUtils.sendMessage(sender, "&e&lMulti-Layer Animations:");
                MessageUtils.sendMessage(sender, "&7- &eepic_welcome &7- Rainbow + Wave + Bounce");
                MessageUtils.sendMessage(sender, "&7- &emysterious_join &7- Glitch + Fade + Matrix");
                MessageUtils.sendMessage(sender, "&7- &efestive_celebration &7- Rainbow + Pulse + Shake");
                MessageUtils.sendMessage(sender, "&7- &esmooth_entrance &7- Fade + Slide + Typing");
                MessageUtils.sendMessage(sender, "&7- &eparty_time &7- Bounce + Pulse + Rainbow + Wave");
                MessageUtils.sendMessage(sender, "&7- &emilestone_celebration &7- All effects combined!");
            }
        } else {
            MessageUtils.sendMessage(sender, "&7Animations disabled in config");
        }
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l2.6. Dynamic Themes System:");
        if (this.plugin.getConfig().getBoolean("themes.enabled", true)) {
            String currentTheme = this.plugin.getMessageManager().getThemeManager().getCurrentTheme();
            String themeInfo = this.plugin.getMessageManager().getThemeManager().getThemeInfo();
            MessageUtils.sendMessage(sender, "&7Current Theme: &e" + currentTheme.toUpperCase());
            MessageUtils.sendMessage(sender, "&7Theme Info: &f" + themeInfo);
            MessageUtils.sendMessage(sender, "&7Available Themes:");
            MessageUtils.sendMessage(sender, "&7- &eSeasonal: &fHalloween, Christmas, Valentine, Easter, Summer, Winter");
            MessageUtils.sendMessage(sender, "&7- &eTime-based: &fMorning, Afternoon, Evening, Night");
            MessageUtils.sendMessage(sender, "&7- &eAuto-detection: &f" + (this.plugin.getConfig().getBoolean("themes.auto-detect", true) ? "Enabled" : "Disabled"));
        } else {
            MessageUtils.sendMessage(sender, "&7Themes disabled in config");
        }
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l2.7. Smart Player Recognition:");
        if (this.plugin.getConfig().getBoolean("smart-recognition.enabled", true)) {
            MessageUtils.sendMessage(sender, "&7Smart recognition enabled! Features:");
            MessageUtils.sendMessage(sender, "&7- &eMilestone Detection: &fJoin count, playtime, streak milestones");
            MessageUtils.sendMessage(sender, "&7- &eReturning Players: &fDifferent messages based on absence duration");
            MessageUtils.sendMessage(sender, "&7- &eBehavior Analysis: &fPeak activity, favorite world, join patterns");
            String milestoneInfo = this.plugin.getMessageManager().getSmartRecognitionManager().getMilestoneInfo(target);
            MessageUtils.sendMessage(sender, "&7Player Data: &f" + milestoneInfo);
        } else {
            MessageUtils.sendMessage(sender, "&7Smart recognition disabled in config");
        }
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l3. PlaceholderAPI Examples:");
        MessageUtils.sendMessage(sender, "&7Join Count: &e" + this.plugin.getDataManager().getJoinCount(target));
        MessageUtils.sendMessage(sender, "&7First Join: &e" + (isFirstJoin ? "Yes" : "No"));
        MessageUtils.sendMessage(sender, "&7Messages Disabled: &e" + this.plugin.getDataManager().hasMessagesDisabled(target));
        MessageUtils.sendMessage(sender, "&7Player Status: &e" + (isFirstJoin ? "New Player" : "Returning Player"));
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l4. Rank System:");
        if (this.plugin.getConfig().getBoolean("custom-ranks.enabled", true)) {
            List customRanks = this.plugin.getConfig().getStringList("custom-ranks.ranks");
            if (!customRanks.isEmpty()) {
                MessageUtils.sendMessage(sender, "&7Custom ranks enabled. Checking permissions:");
                boolean foundRank = false;
                for (String rank : customRanks) {
                    if (!target.hasPermission("welcome.rank." + rank)) continue;
                    MessageUtils.sendMessage(sender, "&7You have &e" + rank.toUpperCase() + " &7rank permissions");
                    foundRank = true;
                    break;
                }
                if (!foundRank) {
                    MessageUtils.sendMessage(sender, "&7No custom rank permissions found");
                }
            } else {
                MessageUtils.sendMessage(sender, "&7Custom ranks enabled but no ranks configured");
            }
        } else {
            MessageUtils.sendMessage(sender, "&7Custom ranks disabled, using default system:");
            String[] defaultRanks = new String[]{"owner", "admin", "mvp", "vip"};
            boolean foundRank = false;
            for (String rank : defaultRanks) {
                if (!target.hasPermission("welcome.rank." + rank)) continue;
                MessageUtils.sendMessage(sender, "&7You have &e" + rank.toUpperCase() + " &7rank permissions");
                foundRank = true;
                break;
            }
            if (!foundRank) {
                MessageUtils.sendMessage(sender, "&7No default rank permissions found");
            }
        }
        MessageUtils.sendMessage(sender, "");
        if (sender.equals((Object)target)) {
            MessageUtils.sendMessage(sender, "&a&l5. Visual Effects (starting in 3 seconds):");
            MessageUtils.sendMessage(sender, "&7- Title effects");
            MessageUtils.sendMessage(sender, "&7- Sound effects");
            MessageUtils.sendMessage(sender, "&7- Particle effects");
            MessageUtils.sendMessage(sender, "&7- Firework effects");
            MessageUtils.sendMessage(sender, "");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Title Effect <<<");
                this.plugin.getEffectManager().sendTitle(target, isFirstJoin);
            }, 60L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Sound Effect <<<");
                this.plugin.getEffectManager().playJoinSound(target, isFirstJoin);
            }, 80L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Particle Effect <<<");
                this.plugin.getEffectManager().playJoinParticles(target, isFirstJoin);
            }, 100L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Firework Effect <<<");
                this.plugin.getEffectManager().launchFireworks(target);
            }, 120L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l=== Showcase Complete! ===");
                MessageUtils.sendMessage((CommandSender)target, "&7All features have been demonstrated.");
                MessageUtils.sendMessage((CommandSender)target, "&7Perfect for screenshots! \ud83d\udcf8");
            }, 140L);
        } else {
            MessageUtils.sendMessage(sender, "&a&l5. Visual Effects:");
            MessageUtils.sendMessage(sender, "&7Effects can only be shown to the target player");
            MessageUtils.sendMessage(sender, "&7Run &e/welcome testall &7on yourself to see effects");
            MessageUtils.sendMessage(sender, "");
            MessageUtils.sendMessage(sender, "&6&l=== Showcase Complete! ===");
        }
    }

    private void handleTestAnim(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /welcome testanim <animation_type> [player]");
            MessageUtils.sendMessage(sender, "&7Available animations: typing, fade, slide, wave, rainbow, glitch, typewriter, bounce, shake, pulse, matrix, scramble");
            return;
        }
        String animationType = SecurityUtils.sanitizeAnimationType(args[1]);
        if (animationType == null) {
            MessageUtils.sendMessage(sender, "&cInvalid animation type format!");
            return;
        }
        if (args.length > 2) {
            String playerName = SecurityUtils.sanitizePlayerName(args[2]);
            if (playerName == null) {
                MessageUtils.sendMessage(sender, "&cInvalid player name format!");
                return;
            }
            target = Bukkit.getPlayer((String)playerName);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", SecurityUtils.sanitizeText(playerName)));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        String testMessage = "&6&lWelcome to our server, &e" + target.getName() + "&6&l!";
        int duration = 60;
        MessageUtils.sendMessage(sender, "&6Testing &e" + animationType + " &6animation for &e" + target.getName() + "&6...");
        AnimationUtils animationUtils = new AnimationUtils(this.plugin);
        animationUtils.animateMessage(target, testMessage, animationType, duration);
    }

    private void handleTestTheme(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /welcome testtheme <theme> [player]");
            MessageUtils.sendMessage(sender, "&7Available themes: " + String.join((CharSequence)", ", this.plugin.getMessageManager().getThemeManager().getAvailableThemes()));
            return;
        }
        String theme = SecurityUtils.sanitizeThemeName(args[1]);
        if (theme == null) {
            MessageUtils.sendMessage(sender, "&cInvalid theme name format!");
            return;
        }
        if (args.length > 2) {
            String playerName = SecurityUtils.sanitizePlayerName(args[2]);
            if (playerName == null) {
                MessageUtils.sendMessage(sender, "&cInvalid player name format!");
                return;
            }
            target = Bukkit.getPlayer((String)playerName);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", SecurityUtils.sanitizeText(playerName)));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        this.plugin.getMessageManager().getThemeManager().setTheme(theme);
        boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(target);
        List<String> themeMessages = this.plugin.getMessageManager().getThemeManager().getThemeMessages("join", isFirstJoin);
        MessageUtils.sendMessage(sender, "&6Testing &e" + theme + " &6theme for &e" + target.getName() + "&6...");
        if (themeMessages != null && !themeMessages.isEmpty()) {
            String message = themeMessages.get(ThreadLocalRandom.current().nextInt(themeMessages.size()));
            String finalMessage = message.replace("{player}", target.getName()).replace("{displayname}", target.getName()).replace("{world}", target.getWorld() != null ? target.getWorld().getName() : "unknown").replace("{online}", String.valueOf(this.plugin.getServer().getOnlinePlayers().size())).replace("{max}", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("{joincount}", String.valueOf(this.plugin.getDataManager().getJoinCount(target)));
            MessageUtils.sendMessage(sender, "&7Theme message: " + finalMessage);
        } else {
            MessageUtils.sendMessage(sender, "&7No theme messages found for " + theme);
        }
        this.plugin.getMessageManager().getThemeManager().setTheme("auto");
    }

    private void handleTestMilestone(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", args[1]));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6Testing milestone detection for &e" + target.getName() + "&6...");
        String milestoneInfo = this.plugin.getMessageManager().getSmartRecognitionManager().getMilestoneInfo(target);
        MessageUtils.sendMessage(sender, "&7Current data: &f" + milestoneInfo);
        String milestoneMessage = this.plugin.getMessageManager().getSmartRecognitionManager().checkMilestones(target, false);
        if (milestoneMessage != null) {
            MessageUtils.sendMessage(sender, "&7Milestone message: " + milestoneMessage);
        } else {
            MessageUtils.sendMessage(sender, "&7No milestone reached");
        }
        String returningMessage = this.plugin.getMessageManager().getSmartRecognitionManager().getReturningPlayerMessage(target);
        if (returningMessage != null) {
            MessageUtils.sendMessage(sender, "&7Returning player message: " + returningMessage);
        } else {
            MessageUtils.sendMessage(sender, "&7No returning player message");
        }
    }

    private void handleTestPlaytime(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", args[1]));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6&l=== Playtime Testing for " + target.getName() + " ===");
        long totalPlaytime = this.plugin.getDataManager().getTotalPlaytime(target);
        long sessionTime = this.plugin.getDataManager().getCurrentSessionTime(target);
        int joinCount = this.plugin.getDataManager().getJoinCount(target);
        MessageUtils.sendMessage(sender, "&7Total Playtime: &e" + totalPlaytime + " hours");
        MessageUtils.sendMessage(sender, "&7Current Session: &e" + sessionTime + " minutes");
        MessageUtils.sendMessage(sender, "&7Join Count: &e" + joinCount);
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&lTesting Playtime Milestones:");
        List milestones = this.plugin.getConfig().getIntegerList("smart-recognition.milestones.playtime-milestones");
        MessageUtils.sendMessage(sender, "&7Configured milestones: &e" + milestones.toString());
        boolean reachedMilestone = false;
        Iterator iterator = milestones.iterator();
        while (iterator.hasNext()) {
            int milestone = (Integer)iterator.next();
            if (totalPlaytime < (long)milestone) continue;
            MessageUtils.sendMessage(sender, "&a\u2713 Reached " + milestone + " hour milestone!");
            reachedMilestone = true;
        }
        if (!reachedMilestone) {
            MessageUtils.sendMessage(sender, "&7No playtime milestones reached yet");
        }
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&6&l=== Playtime Test Complete ===");
        MessageUtils.sendMessage(sender, "&7Playtime is now tracked accurately!");
        MessageUtils.sendMessage(sender, "&7Session time updates every 5 minutes automatically.");
    }

    private void handleStats(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.stats")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                MessageUtils.sendMessage(sender, "&cPlayer must be online to view stats!");
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6&l--- Player Statistics ---");
        MessageUtils.sendMessage(sender, "&ePlayer: &f" + target.getName());
        MessageUtils.sendMessage(sender, "&eJoin Count: &f" + this.plugin.getDataManager().getJoinCount(target));
        MessageUtils.sendMessage(sender, "&eFirst Join: &f" + (this.plugin.getDataManager().isFirstJoin(target) ? "Never" : "Yes"));
        MessageUtils.sendMessage(sender, "&eMessages Enabled: &f" + !this.plugin.getDataManager().hasMessagesDisabled(target));
        MessageUtils.sendMessage(sender, "&eTotal Playtime: &f" + this.plugin.getDataManager().getTotalPlaytime(target) + " hours");
        MessageUtils.sendMessage(sender, "&eCurrent Session: &f" + this.plugin.getDataManager().getCurrentSessionTime(target) + " minutes");
        MessageUtils.sendMessage(sender, "&6&l----------------------");
    }

    private void handleReset(CommandSender sender, String[] args) {
        if (!sender.hasPermission("welcome.reset")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (!this.checkRateLimit(sender, "reset")) {
            return;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /welcome reset <player>");
            return;
        }
        String playerName = SecurityUtils.sanitizePlayerName(args[1]);
        if (playerName == null) {
            MessageUtils.sendMessage(sender, "&cInvalid player name format!");
            return;
        }
        this.plugin.getDataManager().resetPlayerData(playerName);
        MessageUtils.sendMessage(sender, "&aPlayer data reset for &e" + SecurityUtils.sanitizeText(playerName));
    }

    private void handleToggle(CommandSender sender) {
        if (!(sender instanceof Player)) {
            MessageUtils.sendMessage(sender, "&cOnly players can toggle their messages!");
            return;
        }
        if (!sender.hasPermission("welcome.toggle")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        long lastUse = this.commandCooldowns.getOrDefault(uuid, 0L);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUse < 5000L && !player.hasPermission("welcome.effects.bypass")) {
            MessageUtils.sendMessage((CommandSender)player, "&cPlease wait before using this command again!");
            return;
        }
        this.commandCooldowns.put(uuid, currentTime);
        boolean disabled = this.plugin.getDataManager().toggleMessages(player);
        if (disabled) {
            MessageUtils.sendMessage((CommandSender)player, "&cYour join/quit messages have been disabled!");
        } else {
            MessageUtils.sendMessage((CommandSender)player, "&aYour join/quit messages have been enabled!");
        }
    }

    private void handleVersion(CommandSender sender) {
        String version = this.plugin.getDescription().getVersion();
        MessageUtils.sendMessage(sender, "&6WelcomeMessages &ev" + version);
        MessageUtils.sendMessage(sender, "&7Created by &eFiveDollaGobby");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("help", "reload", "test", "testall", "testanim", "testtheme", "testmilestone", "testplaytime", "stats", "reset", "toggle", "version");
            StringUtil.copyPartialMatches((String)args[0], subCommands, completions);
        } else if (args.length == 2) {
            String subCommand2 = args[0].toLowerCase();
            if (subCommand2.equals("test") || subCommand2.equals("testall") || subCommand2.equals("stats") || subCommand2.equals("reset") || subCommand2.equals("testmilestone") || subCommand2.equals("testplaytime")) {
                List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                StringUtil.copyPartialMatches((String)args[1], playerNames, completions);
            } else if (subCommand2.equals("testanim")) {
                List<String> animations = Arrays.asList("typing", "fade", "slide", "wave", "rainbow", "glitch", "typewriter", "bounce", "shake", "pulse", "matrix", "scramble", "epic_welcome", "mysterious_join", "festive_celebration", "smooth_entrance", "party_time", "milestone_celebration");
                StringUtil.copyPartialMatches((String)args[1], animations, completions);
            } else if (subCommand2.equals("testtheme")) {
                List<String> themes = this.plugin.getMessageManager().getThemeManager().getAvailableThemes();
                StringUtil.copyPartialMatches((String)args[1], themes, completions);
            }
        } else if (args.length == 3 && ((subCommand = args[0].toLowerCase()).equals("testanim") || subCommand.equals("testtheme"))) {
            List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            StringUtil.copyPartialMatches((String)args[2], playerNames, completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

