/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.listeners;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoinListener
implements Listener {
    private final WelcomePlugin plugin;

    public PlayerJoinListener(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("messages.join.enabled", true)) {
            return;
        }
        if (this.plugin.getDataManager().hasMessagesDisabled(player)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("messages.join.disable-vanilla", true)) {
            event.setJoinMessage(null);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(player);
            String message = this.plugin.getMessageManager().getJoinMessage(player, isFirstJoin);
            if (message != null && !message.isEmpty()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        if (!onlinePlayer.hasPermission("welcome.see.join")) continue;
                        MessageUtils.sendMessage((CommandSender)onlinePlayer, message);
                    }
                    if (this.plugin.getConfig().getBoolean("messages.join.console", true)) {
                        MessageUtils.sendConsole(message);
                    }
                });
            }
            if (this.plugin.getConfig().getBoolean("effects.title.enabled", true)) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getEffectManager().sendTitle(player, isFirstJoin));
            }
            int effectDelay = this.plugin.getConfig().getInt("effects.delay-ticks", 20);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.plugin.getConfig().getBoolean("effects.sound.enabled", true)) {
                    this.plugin.getEffectManager().playJoinSound(player, isFirstJoin);
                }
                if (this.plugin.getConfig().getBoolean("effects.particles.enabled", true)) {
                    this.plugin.getEffectManager().playJoinParticles(player, isFirstJoin);
                }
                if (this.plugin.getConfig().getBoolean("effects.fireworks.enabled", true) && (isFirstJoin || this.plugin.getConfig().getBoolean("effects.fireworks.all-joins", false))) {
                    this.plugin.getEffectManager().launchFireworks(player);
                }
            }, (long)effectDelay);
            this.plugin.getDataManager().updatePlayerData(player);
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        String message;
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("messages.quit.enabled", true)) {
            return;
        }
        if (this.plugin.getDataManager().hasMessagesDisabled(player)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("messages.quit.disable-vanilla", true)) {
            event.setQuitMessage(null);
        }
        if ((message = this.plugin.getMessageManager().getQuitMessage(player)) != null && !message.isEmpty()) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("welcome.see.quit")) continue;
                MessageUtils.sendMessage((CommandSender)onlinePlayer, message);
            }
            if (this.plugin.getConfig().getBoolean("messages.quit.console", true)) {
                MessageUtils.sendConsole(message);
            }
        }
        this.plugin.getDataManager().setLastSeen(player);
    }
}

