/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.managers;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class ThemeManager {
    private final WelcomePlugin plugin;
    private String currentTheme;
    private long lastThemeCheck;

    public ThemeManager(WelcomePlugin plugin) {
        this.plugin = plugin;
        this.currentTheme = "default";
        this.lastThemeCheck = System.currentTimeMillis();
        this.updateTheme();
    }

    public String getCurrentTheme() {
        long checkInterval = this.plugin.getConfig().getLong("themes.check-interval", 60L) * 60L * 1000L;
        if (System.currentTimeMillis() - this.lastThemeCheck > checkInterval) {
            this.updateTheme();
            this.lastThemeCheck = System.currentTimeMillis();
        }
        return this.currentTheme;
    }

    private void updateTheme() {
        if (!this.plugin.getConfig().getBoolean("themes.enabled", true)) {
            this.currentTheme = "default";
            return;
        }
        String configTheme = this.plugin.getConfig().getString("themes.current", "auto");
        if (!configTheme.equals("auto")) {
            this.currentTheme = configTheme;
            return;
        }
        if (!this.plugin.getConfig().getBoolean("themes.auto-detect", true)) {
            this.currentTheme = "default";
            return;
        }
        String detectedTheme = this.detectTheme();
        this.currentTheme = detectedTheme != null ? detectedTheme : "default";
    }

    private String detectTheme() {
        String timeTheme;
        int priority;
        String seasonalTheme;
        HashMap<String, Integer> activeThemes = new HashMap<String, Integer>();
        if (this.plugin.getConfig().getBoolean("themes.seasonal", true) && (seasonalTheme = this.detectSeasonalTheme()) != null) {
            priority = this.plugin.getConfig().getInt("themes.seasonal." + seasonalTheme + ".priority", 0);
            activeThemes.put(seasonalTheme, priority);
        }
        if (this.plugin.getConfig().getBoolean("themes.time-based.enabled", true) && (timeTheme = this.detectTimeBasedTheme()) != null) {
            priority = this.plugin.getConfig().getInt("themes.time-based." + timeTheme + ".priority", 0);
            activeThemes.put(timeTheme, priority);
        }
        return activeThemes.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    private String detectSeasonalTheme() {
        LocalDate now = LocalDate.now();
        String currentDate = now.format(DateTimeFormatter.ofPattern("MM-dd"));
        ConfigurationSection seasonalThemes = this.plugin.getConfig().getConfigurationSection("themes.seasonal");
        if (seasonalThemes == null) {
            return null;
        }
        for (String theme : seasonalThemes.getKeys(false)) {
            String start = this.plugin.getConfig().getString("themes.seasonal." + theme + ".start");
            String end = this.plugin.getConfig().getString("themes.seasonal." + theme + ".end");
            if (start == null || end == null || !this.isDateInRange(currentDate, start, end)) continue;
            return theme;
        }
        return null;
    }

    private String detectTimeBasedTheme() {
        LocalTime now = LocalTime.now();
        String currentTime = now.format(DateTimeFormatter.ofPattern("HH:mm"));
        ConfigurationSection timeThemes = this.plugin.getConfig().getConfigurationSection("themes.time-based");
        if (timeThemes == null) {
            return null;
        }
        for (String theme : timeThemes.getKeys(false)) {
            if (theme.equals("enabled")) continue;
            String start = this.plugin.getConfig().getString("themes.time-based." + theme + ".start");
            String end = this.plugin.getConfig().getString("themes.time-based." + theme + ".end");
            if (start == null || end == null || !this.isTimeInRange(currentTime, start, end)) continue;
            return theme;
        }
        return null;
    }

    private boolean isDateInRange(String currentDate, String startDate, String endDate) {
        try {
            String[] currentParts = currentDate.split("-");
            String[] startParts = startDate.split("-");
            String[] endParts = endDate.split("-");
            if (currentParts.length != 2 || startParts.length != 2 || endParts.length != 2) {
                this.plugin.getLogger().warning("Invalid date format: " + currentDate + " or " + startDate + " or " + endDate);
                return false;
            }
            int currentMonth = Integer.parseInt(currentParts[0]);
            int currentDay = Integer.parseInt(currentParts[1]);
            int startMonth = Integer.parseInt(startParts[0]);
            int startDay = Integer.parseInt(startParts[1]);
            int endMonth = Integer.parseInt(endParts[0]);
            int endDay = Integer.parseInt(endParts[1]);
            if (currentMonth < 1 || currentMonth > 12 || startMonth < 1 || startMonth > 12 || endMonth < 1 || endMonth > 12) {
                this.plugin.getLogger().warning("Invalid month in date: " + currentDate + " or " + startDate + " or " + endDate);
                return false;
            }
            if (startMonth > endMonth) {
                return currentMonth > startMonth || currentMonth == startMonth && currentDay >= startDay || currentMonth < endMonth || currentMonth == endMonth && currentDay <= endDay;
            }
            return (currentMonth > startMonth || currentMonth == startMonth && currentDay >= startDay) && (currentMonth < endMonth || currentMonth == endMonth && currentDay <= endDay);
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Error parsing date range (invalid number): " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error parsing date range: " + e.getMessage());
            return false;
        }
    }

    private boolean isTimeInRange(String currentTime, String startTime, String endTime) {
        try {
            String[] currentParts = currentTime.split(":");
            String[] startParts = startTime.split(":");
            String[] endParts = endTime.split(":");
            int currentHour = Integer.parseInt(currentParts[0]);
            int currentMinute = Integer.parseInt(currentParts[1]);
            int startHour = Integer.parseInt(startParts[0]);
            int startMinute = Integer.parseInt(startParts[1]);
            int endHour = Integer.parseInt(endParts[0]);
            int endMinute = Integer.parseInt(endParts[1]);
            int currentMinutes = currentHour * 60 + currentMinute;
            int startMinutes = startHour * 60 + startMinute;
            int endMinutes = endHour * 60 + endMinute;
            if (startMinutes > endMinutes) {
                return currentMinutes >= startMinutes || currentMinutes <= endMinutes;
            }
            return currentMinutes >= startMinutes && currentMinutes <= endMinutes;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error parsing time range: " + e.getMessage());
            return false;
        }
    }

    public List<String> getThemeMessages(String messageType, boolean isFirstJoin) {
        String theme = this.getCurrentTheme();
        if (theme.equals("default")) {
            return null;
        }
        String path = "messages.join.themes." + theme + "." + (isFirstJoin ? "first-time" : "default");
        List messages = this.plugin.getMessagesConfig().getStringList(path);
        return messages.isEmpty() ? null : messages;
    }

    public List<String> getAvailableThemes() {
        ConfigurationSection timeThemes;
        ArrayList<String> themes = new ArrayList<String>();
        themes.add("default");
        ConfigurationSection seasonalThemes = this.plugin.getConfig().getConfigurationSection("themes.seasonal");
        if (seasonalThemes != null) {
            themes.addAll(seasonalThemes.getKeys(false));
        }
        if ((timeThemes = this.plugin.getConfig().getConfigurationSection("themes.time-based")) != null) {
            for (String theme : timeThemes.getKeys(false)) {
                if (theme.equals("enabled")) continue;
                themes.add(theme);
            }
        }
        return themes;
    }

    public void setTheme(String theme) {
        this.currentTheme = theme;
    }

    public String getThemeInfo() {
        String theme = this.getCurrentTheme();
        if (theme.equals("default")) {
            return "Default theme (no special styling)";
        }
        String description = this.plugin.getConfig().getString("themes.seasonal." + theme + ".description", this.plugin.getConfig().getString("themes.time-based." + theme + ".description", "Custom theme"));
        return theme.toUpperCase() + " theme: " + description;
    }
}

