/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.utils;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigValidator {
    private final WelcomePlugin plugin;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public ConfigValidator(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean validateConfig() {
        this.errors.clear();
        this.warnings.clear();
        FileConfiguration config = this.plugin.getConfig();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        this.validateGeneralSettings(config);
        this.validateMessageSettings(config, messagesConfig);
        this.validateEffects(config);
        this.validatePerformanceSettings(config);
        this.logValidationResults();
        return this.errors.isEmpty();
    }

    private void validateGeneralSettings(FileConfiguration config) {
        int saveInterval = config.getInt("general.save-interval", 10);
        if (saveInterval < 1) {
            this.errors.add("general.save-interval must be at least 1 minute");
        } else if (saveInterval > 1440) {
            this.warnings.add("general.save-interval is very high (" + saveInterval + " minutes) - consider reducing for better data safety");
        }
    }

    private void validateMessageSettings(FileConfiguration config, FileConfiguration messagesConfig) {
        boolean rgbEnabled;
        List defaultQuitMessages;
        List defaultJoinMessages;
        if (config.getBoolean("messages.join.enabled", true) && (defaultJoinMessages = messagesConfig.getStringList("messages.join.default")).isEmpty()) {
            this.errors.add("messages.join.enabled is true but no default join messages found");
        }
        if (config.getBoolean("messages.quit.enabled", true) && (defaultQuitMessages = messagesConfig.getStringList("messages.quit.default")).isEmpty()) {
            this.errors.add("messages.quit.enabled is true but no default quit messages found");
        }
        if (rgbEnabled = config.getBoolean("messages.rgb.enabled", true)) {
            try {
                ChatColor.of((String)"#FF0000");
            }
            catch (Exception e) {
                this.warnings.add("RGB colors enabled but server may not support them (requires 1.16+)");
            }
        }
    }

    private void validateEffects(FileConfiguration config) {
        if (config.getBoolean("effects.sound.enabled", true)) {
            this.validateSound(config, "effects.sound.first-join", "UI_TOAST_CHALLENGE_COMPLETE");
            this.validateSound(config, "effects.sound.regular", "ENTITY_PLAYER_LEVELUP");
        }
        if (config.getBoolean("effects.particles.enabled", true)) {
            this.validateParticle(config, "effects.particles.first-join", "TOTEM");
            this.validateParticle(config, "effects.particles.regular", "VILLAGER_HAPPY");
        }
        if (config.getBoolean("effects.title.enabled", true)) {
            int fadeIn = config.getInt("effects.title.fade-in", 10);
            int stay = config.getInt("effects.title.stay", 70);
            int fadeOut = config.getInt("effects.title.fade-out", 20);
            if (fadeIn < 0 || fadeIn > 100) {
                this.errors.add("effects.title.fade-in must be between 0 and 100");
            }
            if (stay < 0 || stay > 200) {
                this.errors.add("effects.title.stay must be between 0 and 200");
            }
            if (fadeOut < 0 || fadeOut > 100) {
                this.errors.add("effects.title.fade-out must be between 0 and 100");
            }
        }
        if (config.getBoolean("effects.fireworks.enabled", true)) {
            int amount = config.getInt("effects.fireworks.amount", 3);
            int delay = config.getInt("effects.fireworks.delay-between", 20);
            if (amount < 1 || amount > 20) {
                this.errors.add("effects.fireworks.amount must be between 1 and 20");
            }
            if (delay < 1 || delay > 200) {
                this.errors.add("effects.fireworks.delay-between must be between 1 and 200");
            }
        }
    }

    private void validatePerformanceSettings(FileConfiguration config) {
        int cacheTime = config.getInt("performance.cache-time", 5);
        int maxCacheSize = config.getInt("performance.max-cache-size", 100);
        if (cacheTime < 1 || cacheTime > 60) {
            this.errors.add("performance.cache-time must be between 1 and 60 minutes");
        }
        if (maxCacheSize < 10 || maxCacheSize > 1000) {
            this.errors.add("performance.max-cache-size must be between 10 and 1000");
        }
    }

    private void validateSound(FileConfiguration config, String path, String defaultValue) {
        String soundName = config.getString(path, defaultValue);
        try {
            Sound sound = Sound.valueOf((String)soundName);
        }
        catch (IllegalArgumentException e) {
            this.errors.add("Invalid sound '" + soundName + "' in " + path + " - using default");
            config.set(path, (Object)defaultValue);
        }
    }

    private void validateParticle(FileConfiguration config, String path, String defaultValue) {
        String particleName = config.getString(path, defaultValue);
        try {
            Particle.valueOf((String)particleName);
        }
        catch (IllegalArgumentException e) {
            this.errors.add("Invalid particle '" + particleName + "' in " + path + " - using default");
            config.set(path, (Object)defaultValue);
        }
    }

    private void logValidationResults() {
        if (!this.errors.isEmpty()) {
            MessageUtils.sendConsole("&cConfiguration validation failed:");
            for (String error : this.errors) {
                MessageUtils.sendConsole("&c- " + error);
            }
            MessageUtils.sendConsole("&cPlease fix these errors and reload the plugin!");
        }
        if (!this.warnings.isEmpty()) {
            MessageUtils.sendConsole("&eConfiguration warnings:");
            for (String warning : this.warnings) {
                MessageUtils.sendConsole("&e- " + warning);
            }
        }
        if (this.errors.isEmpty() && this.warnings.isEmpty()) {
            MessageUtils.sendConsole("&aConfiguration validation passed!");
        }
    }

    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }

    public List<String> getWarnings() {
        return new ArrayList<String>(this.warnings);
    }
}

