/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.commands;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class WelcomeCommand
implements CommandExecutor,
TabCompleter {
    private final WelcomePlugin plugin;
    private final Map<UUID, Long> commandCooldowns = new HashMap<UUID, Long>();

    public WelcomeCommand(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "test": {
                this.handleTest(sender, args);
                break;
            }
            case "stats": {
                this.handleStats(sender, args);
                break;
            }
            case "reset": {
                this.handleReset(sender, args);
                break;
            }
            case "toggle": {
                this.handleToggle(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            default: {
                MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.unknown-command"));
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission("welcome.use")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.help.header"));
        List commands = this.plugin.getMessagesConfig().getStringList("commands.help.commands");
        for (String cmd : commands) {
            if (cmd.contains("reload") && !sender.hasPermission("welcome.reload") || cmd.contains("test") && !sender.hasPermission("welcome.test") || cmd.contains("stats") && !sender.hasPermission("welcome.stats") || cmd.contains("reset") && !sender.hasPermission("welcome.reset")) continue;
            MessageUtils.sendMessage(sender, cmd);
        }
        MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.help.footer"));
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("welcome.reload")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        try {
            this.plugin.reload();
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.reload-success"));
        }
        catch (Exception e) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.reload-error"));
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
        }
    }

    private void handleTest(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", args[1]));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(target);
        String joinMessage = this.plugin.getMessageManager().getJoinMessage(target, isFirstJoin);
        MessageUtils.sendMessage(sender, "&6Testing join message for &e" + target.getName() + "&6:");
        MessageUtils.sendMessage(sender, joinMessage);
        String quitMessage = this.plugin.getMessageManager().getQuitMessage(target);
        MessageUtils.sendMessage(sender, "&6Quit message:");
        MessageUtils.sendMessage(sender, quitMessage);
        if (sender.equals((Object)target)) {
            MessageUtils.sendMessage(sender, "&6Testing effects in 2 seconds...");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.plugin.getEffectManager().sendTitle(target, isFirstJoin);
                this.plugin.getEffectManager().playJoinSound(target, isFirstJoin);
                this.plugin.getEffectManager().playJoinParticles(target, isFirstJoin);
            }, 40L);
        }
    }

    private void handleStats(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.stats")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                MessageUtils.sendMessage(sender, "&cPlayer must be online to view stats!");
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6&l--- Player Statistics ---");
        MessageUtils.sendMessage(sender, "&ePlayer: &f" + target.getName());
        MessageUtils.sendMessage(sender, "&eJoin Count: &f" + this.plugin.getDataManager().getJoinCount(target));
        MessageUtils.sendMessage(sender, "&eFirst Join: &f" + (this.plugin.getDataManager().isFirstJoin(target) ? "Never" : "Yes"));
        MessageUtils.sendMessage(sender, "&eMessages Enabled: &f" + !this.plugin.getDataManager().hasMessagesDisabled(target));
        MessageUtils.sendMessage(sender, "&6&l----------------------");
    }

    private void handleReset(CommandSender sender, String[] args) {
        if (!sender.hasPermission("welcome.reset")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /welcome reset <player>");
            return;
        }
        String playerName = args[1];
        this.plugin.getDataManager().resetPlayerData(playerName);
        MessageUtils.sendMessage(sender, "&aPlayer data reset for &e" + playerName);
    }

    private void handleToggle(CommandSender sender) {
        if (!(sender instanceof Player)) {
            MessageUtils.sendMessage(sender, "&cOnly players can toggle their messages!");
            return;
        }
        if (!sender.hasPermission("welcome.toggle")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        long lastUse = this.commandCooldowns.getOrDefault(uuid, 0L);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUse < 5000L && !player.hasPermission("welcome.effects.bypass")) {
            MessageUtils.sendMessage((CommandSender)player, "&cPlease wait before using this command again!");
            return;
        }
        this.commandCooldowns.put(uuid, currentTime);
        boolean disabled = this.plugin.getDataManager().toggleMessages(player);
        if (disabled) {
            MessageUtils.sendMessage((CommandSender)player, "&cYour join/quit messages have been disabled!");
        } else {
            MessageUtils.sendMessage((CommandSender)player, "&aYour join/quit messages have been enabled!");
        }
    }

    private void handleVersion(CommandSender sender) {
        MessageUtils.sendMessage(sender, "&6WelcomeMessages &ev" + this.plugin.getDescription().getVersion());
        MessageUtils.sendMessage(sender, "&7Created by &eFiveDollaGobby");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("help", "reload", "test", "stats", "reset", "toggle", "version");
            StringUtil.copyPartialMatches((String)args[0], subCommands, completions);
        } else if (args.length == 2 && ((subCommand = args[0].toLowerCase()).equals("test") || subCommand.equals("stats") || subCommand.equals("reset"))) {
            List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            StringUtil.copyPartialMatches((String)args[1], playerNames, completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

