/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.managers;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DataManager {
    private final WelcomePlugin plugin;
    private final Map<UUID, PlayerData> playerCache = new ConcurrentHashMap<UUID, PlayerData>();
    private File dataFile;
    private FileConfiguration dataConfig;
    private int totalUniqueJoins = 0;

    public DataManager(WelcomePlugin plugin) {
        this.plugin = plugin;
        this.loadDataFile();
        this.startAutoSave();
    }

    private void loadDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "playerdata.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create playerdata.yml: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.totalUniqueJoins = this.dataConfig.getInt("total-unique-joins", 0);
        if (this.dataConfig.contains("players")) {
            for (String uuidStr : this.dataConfig.getConfigurationSection("players").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    PlayerData data = new PlayerData();
                    data.joinCount = this.dataConfig.getInt("players." + uuidStr + ".join-count", 0);
                    data.firstJoinTime = this.dataConfig.getLong("players." + uuidStr + ".first-join", 0L);
                    data.lastSeenTime = this.dataConfig.getLong("players." + uuidStr + ".last-seen", 0L);
                    data.messagesDisabled = this.dataConfig.getBoolean("players." + uuidStr + ".messages-disabled", false);
                    this.playerCache.put(uuid, data);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in playerdata: " + uuidStr);
                }
            }
        }
    }

    private void startAutoSave() {
        int interval = this.plugin.getConfig().getInt("general.save-interval", 10) * 20 * 60;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::saveData, (long)interval, (long)interval);
    }

    public void saveData() {
        for (Map.Entry<UUID, PlayerData> entry : this.playerCache.entrySet()) {
            String path = "players." + entry.getKey().toString();
            PlayerData data = entry.getValue();
            this.dataConfig.set(path + ".join-count", (Object)data.joinCount);
            this.dataConfig.set(path + ".first-join", (Object)data.firstJoinTime);
            this.dataConfig.set(path + ".last-seen", (Object)data.lastSeenTime);
            this.dataConfig.set(path + ".messages-disabled", (Object)data.messagesDisabled);
        }
        this.dataConfig.set("total-unique-joins", (Object)this.totalUniqueJoins);
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save playerdata.yml: " + e.getMessage());
        }
    }

    public boolean isFirstJoin(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data.firstJoinTime == 0L;
    }

    public void updatePlayerData(Player player) {
        PlayerData data = this.getPlayerData(player);
        if (data.firstJoinTime == 0L) {
            data.firstJoinTime = System.currentTimeMillis();
            ++this.totalUniqueJoins;
        }
        ++data.joinCount;
        data.lastSeenTime = System.currentTimeMillis();
    }

    public void setLastSeen(Player player) {
        PlayerData data = this.getPlayerData(player);
        data.lastSeenTime = System.currentTimeMillis();
    }

    public int getJoinCount(Player player) {
        return this.getPlayerData((Player)player).joinCount;
    }

    public int getTotalUniqueJoins() {
        return this.totalUniqueJoins;
    }

    public boolean hasMessagesDisabled(Player player) {
        return this.getPlayerData((Player)player).messagesDisabled;
    }

    public boolean toggleMessages(Player player) {
        PlayerData data = this.getPlayerData(player);
        data.messagesDisabled = !data.messagesDisabled;
        return data.messagesDisabled;
    }

    public void resetPlayerData(String playerName) {
        Player onlinePlayer = Bukkit.getPlayer((String)playerName);
        if (onlinePlayer != null) {
            this.playerCache.remove(onlinePlayer.getUniqueId());
            this.dataConfig.set("players." + onlinePlayer.getUniqueId().toString(), null);
        } else {
            for (String uuidStr : this.dataConfig.getConfigurationSection("players").getKeys(false)) {
                String storedName = this.dataConfig.getString("players." + uuidStr + ".name");
                if (!playerName.equalsIgnoreCase(storedName)) continue;
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    this.playerCache.remove(uuid);
                    this.dataConfig.set("players." + uuidStr, null);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        this.saveData();
    }

    private PlayerData getPlayerData(Player player) {
        return this.playerCache.computeIfAbsent(player.getUniqueId(), k -> new PlayerData());
    }

    public PlayerData getPlayerDataPublic(Player player) {
        return this.getPlayerData(player);
    }

    public void cleanCache() {
        long maxCacheTime = (long)(this.plugin.getConfig().getInt("performance.cache-time", 5) * 60) * 1000L;
        long currentTime = System.currentTimeMillis();
        this.playerCache.entrySet().removeIf(entry -> {
            Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
            if (player == null || !player.isOnline()) {
                return currentTime - ((PlayerData)entry.getValue()).lastSeenTime > maxCacheTime;
            }
            return false;
        });
    }

    public static class PlayerData {
        public int joinCount = 0;
        public long firstJoinTime = 0L;
        public long lastSeenTime = 0L;
        public boolean messagesDisabled = false;
    }
}

