/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.managers;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EffectManager {
    private final WelcomePlugin plugin;
    private final Random random = new Random();

    public EffectManager(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    public void reload() {
    }

    public void sendTitle(Player player, boolean isFirstJoin) {
        String subtitle;
        String title;
        int fadeIn = this.plugin.getConfig().getInt("effects.title.fade-in", 10);
        int stay = this.plugin.getConfig().getInt("effects.title.stay", 70);
        int fadeOut = this.plugin.getConfig().getInt("effects.title.fade-out", 20);
        if (isFirstJoin) {
            title = this.plugin.getConfig().getString("effects.title.first-join.title", "&6&lWELCOME!");
            subtitle = this.plugin.getConfig().getString("effects.title.first-join.subtitle", "&eEnjoy your stay, {player}!");
        } else {
            title = this.plugin.getConfig().getString("effects.title.regular.title", "&a&lWelcome Back!");
            subtitle = this.plugin.getConfig().getString("effects.title.regular.subtitle", "&7Good to see you again, {player}!");
        }
        title = MessageUtils.colorize(title.replace("{player}", player.getName()));
        subtitle = MessageUtils.colorize(subtitle.replace("{player}", player.getName()));
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public void playJoinSound(Player player, boolean isFirstJoin) {
        float volume = (float)this.plugin.getConfig().getDouble("effects.sound.volume", 1.0);
        float pitch = (float)this.plugin.getConfig().getDouble("effects.sound.pitch", 1.0);
        try {
            Sound regularSound;
            Sound firstJoinSound;
            Sound sound = isFirstJoin ? (firstJoinSound = Sound.valueOf((String)this.plugin.getConfig().getString("effects.sound.first-join", "UI_TOAST_CHALLENGE_COMPLETE"))) : (regularSound = Sound.valueOf((String)this.plugin.getConfig().getString("effects.sound.regular", "ENTITY_PLAYER_LEVELUP")));
            if (this.plugin.getConfig().getBoolean("effects.sound.to-player", true)) {
                player.playSound(player.getLocation(), sound, volume, pitch);
            }
            if (this.plugin.getConfig().getBoolean("effects.sound.to-others", false)) {
                int radius = this.plugin.getConfig().getInt("effects.sound.radius", 10);
                player.getNearbyEntities((double)radius, (double)radius, (double)radius).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).forEach(p -> p.playSound(player.getLocation(), sound, volume * 0.5f, pitch));
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound in config: " + e.getMessage());
        }
    }

    public void playJoinParticles(final Player player, boolean isFirstJoin) {
        int count = this.plugin.getConfig().getInt("effects.particles.count", 50);
        double offsetX = this.plugin.getConfig().getDouble("effects.particles.offset.x", 0.5);
        double offsetY = this.plugin.getConfig().getDouble("effects.particles.offset.y", 1.0);
        double offsetZ = this.plugin.getConfig().getDouble("effects.particles.offset.z", 0.5);
        final double speed = this.plugin.getConfig().getDouble("effects.particles.speed", 0.1);
        try {
            final Particle particle = isFirstJoin ? Particle.valueOf((String)this.plugin.getConfig().getString("effects.particles.first-join", "TOTEM")) : Particle.valueOf((String)this.plugin.getConfig().getString("effects.particles.regular", "VILLAGER_HAPPY"));
            final Location loc = player.getLocation();
            if (this.plugin.getConfig().getBoolean("effects.particles.animated", true)) {
                new BukkitRunnable(this){
                    int iteration = 0;
                    final int maxIterations = 20;

                    public void run() {
                        if (this.iteration >= 20 || !player.isOnline()) {
                            this.cancel();
                            return;
                        }
                        double angle = Math.PI * 2 * (double)this.iteration / 20.0;
                        double x = Math.cos(angle) * 1.5;
                        double z = Math.sin(angle) * 1.5;
                        double y = (double)this.iteration * 0.15;
                        Location particleLoc = loc.clone().add(x, y, z);
                        player.getWorld().spawnParticle(particle, particleLoc, 5, 0.1, 0.1, 0.1, speed);
                        ++this.iteration;
                    }
                }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
            } else {
                player.getWorld().spawnParticle(particle, loc.add(0.0, 1.0, 0.0), count, offsetX, offsetY, offsetZ, speed);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid particle in config: " + e.getMessage());
        }
    }

    public void launchFireworks(final Player player) {
        final int amount = this.plugin.getConfig().getInt("effects.fireworks.amount", 3);
        int delayBetween = this.plugin.getConfig().getInt("effects.fireworks.delay-between", 20);
        new BukkitRunnable(){
            int launched = 0;

            public void run() {
                if (this.launched >= amount || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location loc = player.getLocation();
                double offsetX = (EffectManager.this.random.nextDouble() - 0.5) * 4.0;
                double offsetZ = (EffectManager.this.random.nextDouble() - 0.5) * 4.0;
                loc.add(offsetX, 0.0, offsetZ);
                Firework fw = (Firework)player.getWorld().spawnEntity(loc, EntityType.FIREWORK_ROCKET);
                FireworkMeta fwMeta = fw.getFireworkMeta();
                FireworkEffect.Type type = FireworkEffect.Type.values()[EffectManager.this.random.nextInt(FireworkEffect.Type.values().length)];
                Color color = EffectManager.this.getRandomColor();
                Color fadeColor = EffectManager.this.getRandomColor();
                FireworkEffect effect = FireworkEffect.builder().withColor(color).withFade(fadeColor).with(type).trail(EffectManager.this.random.nextBoolean()).flicker(EffectManager.this.random.nextBoolean()).build();
                fwMeta.addEffect(effect);
                fwMeta.setPower(EffectManager.this.random.nextInt(2) + 1);
                fw.setFireworkMeta(fwMeta);
                ++this.launched;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delayBetween);
    }

    private Color getRandomColor() {
        Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW, Color.PURPLE, Color.ORANGE, Color.WHITE, Color.AQUA, Color.FUCHSIA, Color.LIME, Color.TEAL, Color.SILVER};
        return colors[this.random.nextInt(colors.length)];
    }
}

