/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.managers;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MessageManager {
    private final WelcomePlugin plugin;
    private final Map<String, List<String>> rankJoinMessages = new HashMap<String, List<String>>();
    private final Map<String, List<String>> rankQuitMessages = new HashMap<String, List<String>>();
    private List<String> defaultJoinMessages;
    private List<String> defaultQuitMessages;
    private List<String> firstJoinMessages;

    public MessageManager(WelcomePlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        ConfigurationSection quitRanks;
        this.rankJoinMessages.clear();
        this.rankQuitMessages.clear();
        this.defaultJoinMessages = this.plugin.getMessagesConfig().getStringList("messages.join.default");
        this.defaultQuitMessages = this.plugin.getMessagesConfig().getStringList("messages.quit.default");
        this.firstJoinMessages = this.plugin.getMessagesConfig().getStringList("messages.join.first-time");
        ConfigurationSection joinRanks = this.plugin.getMessagesConfig().getConfigurationSection("messages.join.ranks");
        if (joinRanks != null) {
            for (String rank : joinRanks.getKeys(false)) {
                List messages = this.plugin.getMessagesConfig().getStringList("messages.join.ranks." + rank);
                this.rankJoinMessages.put(rank.toLowerCase(), messages);
            }
        }
        if ((quitRanks = this.plugin.getMessagesConfig().getConfigurationSection("messages.quit.ranks")) != null) {
            for (String rank : quitRanks.getKeys(false)) {
                List messages = this.plugin.getMessagesConfig().getStringList("messages.quit.ranks." + rank);
                this.rankQuitMessages.put(rank.toLowerCase(), messages);
            }
        }
    }

    public String getJoinMessage(Player player, boolean isFirstJoin) {
        ArrayList<Object> possibleMessages = new ArrayList();
        if (isFirstJoin && !this.firstJoinMessages.isEmpty()) {
            possibleMessages = new ArrayList<String>(this.firstJoinMessages);
        } else {
            String highestRank = this.getHighestRank(player);
            if (highestRank != null && this.rankJoinMessages.containsKey(highestRank)) {
                possibleMessages.addAll((Collection<Object>)this.rankJoinMessages.get(highestRank));
            }
            if (possibleMessages.isEmpty() || this.plugin.getConfig().getBoolean("messages.combine-rank-default", false)) {
                possibleMessages.addAll(this.defaultJoinMessages);
            }
        }
        if (!possibleMessages.isEmpty()) {
            String message = (String)possibleMessages.get(ThreadLocalRandom.current().nextInt(possibleMessages.size()));
            return this.replacePlaceholders(message, player, isFirstJoin);
        }
        return null;
    }

    public String getQuitMessage(Player player) {
        ArrayList<String> possibleMessages = new ArrayList<String>();
        String highestRank = this.getHighestRank(player);
        if (highestRank != null && this.rankQuitMessages.containsKey(highestRank)) {
            possibleMessages.addAll((Collection)this.rankQuitMessages.get(highestRank));
        }
        if (possibleMessages.isEmpty() || this.plugin.getConfig().getBoolean("messages.combine-rank-default", false)) {
            possibleMessages.addAll(this.defaultQuitMessages);
        }
        if (!possibleMessages.isEmpty()) {
            String message = (String)possibleMessages.get(ThreadLocalRandom.current().nextInt(possibleMessages.size()));
            return this.replacePlaceholders(message, player, false);
        }
        return null;
    }

    private String getHighestRank(Player player) {
        String[] rankPriority = new String[]{"owner", "admin", "mvp", "vip"};
        if (player.isOp() && this.plugin.getConfig().getBoolean("messages.op-uses-default", false)) {
            return null;
        }
        for (String rank : rankPriority) {
            if (!player.hasPermission("welcome.rank." + rank)) continue;
            return rank;
        }
        return null;
    }

    private String replacePlaceholders(String message, Player player, boolean isFirstJoin) {
        message = message.replace("{player}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{world}", player.getWorld().getName()).replace("{online}", String.valueOf(this.plugin.getServer().getOnlinePlayers().size())).replace("{max}", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("{joincount}", String.valueOf(this.plugin.getDataManager().getJoinCount(player)));
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        String timeGreeting = hour < 12 ? "morning" : (hour < 18 ? "afternoon" : "evening");
        message = message.replace("{time}", timeGreeting);
        if (isFirstJoin) {
            message = message.replace("{ordinal}", this.getOrdinal(this.plugin.getDataManager().getTotalUniqueJoins()));
        }
        if (this.plugin.getConfig().getBoolean("messages.rgb.enabled", true)) {
            return MessageUtils.colorize(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String getOrdinal(int number) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (number % 100) {
            case 11: 
            case 12: 
            case 13: {
                return number + "th";
            }
        }
        return number + suffixes[number % 10];
    }
}

