/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.placeholders;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.managers.DataManager;
import com.FiveDollaGobby.WelcomeMessages.placeholders.PlaceholderAPIExpansion;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.bukkit.entity.Player;

public class WelcomePlaceholders {
    private final WelcomePlugin plugin;
    private Object expansion;

    public WelcomePlaceholders(WelcomePlugin plugin) {
        this.plugin = plugin;
        try {
            Class.forName("me.clip.placeholderapi.expansion.PlaceholderExpansion");
            this.expansion = new PlaceholderAPIExpansion(plugin);
        }
        catch (ClassNotFoundException e) {
            this.expansion = null;
        }
    }

    public boolean register() {
        if (this.expansion == null) {
            return false;
        }
        try {
            this.expansion.getClass().getMethod("register", new Class[0]).invoke(this.expansion, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getPlaceholder(Player player, String params) {
        if (player == null) {
            return "";
        }
        DataManager dataManager = this.plugin.getDataManager();
        if (dataManager == null) {
            return "";
        }
        switch (params.toLowerCase()) {
            case "joincount": 
            case "joins": {
                return String.valueOf(dataManager.getJoinCount(player));
            }
            case "firstjoin": 
            case "isfirstjoin": {
                return dataManager.isFirstJoin(player) ? "true" : "false";
            }
            case "messagesdisabled": 
            case "messages_off": {
                return dataManager.hasMessagesDisabled(player) ? "true" : "false";
            }
            case "lastseen": {
                long lastSeen = dataManager.getPlayerDataPublic((Player)player).lastSeenTime;
                if (lastSeen == 0L) {
                    return "Never";
                }
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(lastSeen));
            }
            case "firstjointime": {
                long firstJoin = dataManager.getPlayerDataPublic((Player)player).firstJoinTime;
                if (firstJoin == 0L) {
                    return "Never";
                }
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(firstJoin));
            }
            case "time_since_last_seen": {
                long lastSeenTime = dataManager.getPlayerDataPublic((Player)player).lastSeenTime;
                if (lastSeenTime == 0L) {
                    return "Never";
                }
                return this.formatTimeAgo(System.currentTimeMillis() - lastSeenTime);
            }
            case "time_since_first_join": {
                long firstJoinTime = dataManager.getPlayerDataPublic((Player)player).firstJoinTime;
                if (firstJoinTime == 0L) {
                    return "Never";
                }
                return this.formatTimeAgo(System.currentTimeMillis() - firstJoinTime);
            }
            case "total_unique_joins": 
            case "server_joins": {
                return String.valueOf(dataManager.getTotalUniqueJoins());
            }
            case "join_ordinal": {
                int totalJoins = dataManager.getTotalUniqueJoins();
                return this.getOrdinal(totalJoins);
            }
            case "player_ordinal": {
                return this.getOrdinal(dataManager.getJoinCount(player));
            }
            case "status": {
                if (dataManager.isFirstJoin(player)) {
                    return "New Player";
                }
                if (dataManager.hasMessagesDisabled(player)) {
                    return "Messages Disabled";
                }
                return "Regular Player";
            }
            case "rank": {
                return this.getPlayerRank(player);
            }
            case "time_greeting": {
                return this.getTimeGreeting();
            }
            case "server_uptime": {
                return "Unknown";
            }
        }
        return null;
    }

    private String formatTimeAgo(long timeDiff) {
        long seconds = timeDiff / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + " day" + (days == 1L ? "" : "s") + " ago";
        }
        if (hours > 0L) {
            return hours + " hour" + (hours == 1L ? "" : "s") + " ago";
        }
        if (minutes > 0L) {
            return minutes + " minute" + (minutes == 1L ? "" : "s") + " ago";
        }
        return seconds + " second" + (seconds == 1L ? "" : "s") + " ago";
    }

    private String getOrdinal(int number) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (number % 100) {
            case 11: 
            case 12: 
            case 13: {
                return number + "th";
            }
        }
        return number + suffixes[number % 10];
    }

    private String getTimeGreeting() {
        int hour = Calendar.getInstance().get(11);
        if (hour < 12) {
            return "morning";
        }
        if (hour < 18) {
            return "afternoon";
        }
        return "evening";
    }

    private String getPlayerRank(Player player) {
        String[] rankPriority;
        for (String rank : rankPriority = new String[]{"owner", "admin", "mvp", "vip"}) {
            if (!player.hasPermission("welcome.rank." + rank)) continue;
            return rank.toUpperCase();
        }
        return "DEFAULT";
    }

    private DataManager.PlayerData getPlayerData(Player player) {
        return this.plugin.getDataManager().getPlayerDataPublic(player);
    }
}

